/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.ClassLoaderLock;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.JarLoader;

final class UpdateLoader
implements LockOwner {
    private static final String[] RESTRICTED_PACKAGES = new String[]{"javax.", "org.apache.derby."};
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final LockFactory lf;
    private final ShExLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private final CompatibilitySpace compat;
    private boolean needReload;
    private JarReader jarReader;

    UpdateLoader(String classpath, DatabaseClasses parent, boolean verbose, boolean normalizeToUpper) throws StandardException {
        this.normalizeToUpper = normalizeToUpper;
        this.parent = parent;
        this.lf = (LockFactory)Monitor.getServiceModule(parent, "org.apache.derby.iapi.services.locks.LockFactory");
        CompatibilitySpace compatibilitySpace = this.compat = this.lf != null ? this.lf.createCompatibilitySpace(this) : null;
        if (verbose) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new ClassLoaderLock(this);
        this.initializeFromClassPath(classpath);
    }

    private void initializeFromClassPath(String classpath) throws StandardException {
        final String[][] elements = IdUtil.parseDbClassPath(classpath);
        final int jarCount = elements.length;
        this.jarList = new JarLoader[jarCount];
        if (jarCount != 0) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (int i = 0; i < jarCount; ++i) {
                        ((UpdateLoader)UpdateLoader.this).jarList[i] = new JarLoader(UpdateLoader.this, elements[i], UpdateLoader.this.vs);
                    }
                    return null;
                }
            });
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C005", classpath));
        }
        this.thisClasspath = classpath;
        this.initDone = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        UpdateLoader updateLoader;
        boolean unlockLoader;
        block17: {
            Class clazz;
            block16: {
                JarLoader jl = null;
                unlockLoader = false;
                try {
                    try {
                        unlockLoader = this.lockClassLoader(ShExQual.SH);
                        updateLoader = this;
                        synchronized (updateLoader) {
                            Class clazz2;
                            if (this.needReload) {
                                this.reload();
                            }
                            if ((clazz2 = this.checkLoaded(className, resolve)) != null) {
                                Class clazz3 = clazz2;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl12 : MonitorExitStatement: MONITOREXIT : var5_5
                                Object var13_11 = null;
                                if (!unlockLoader) return clazz3;
                                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                                return clazz3;
                            }
                            for (int i = 0; i < RESTRICTED_PACKAGES.length; ++i) {
                                if (!className.startsWith(RESTRICTED_PACKAGES[i])) continue;
                                throw new ClassNotFoundException(className);
                            }
                            String jvmClassName = className.replace('.', '/').concat(".class");
                            if (!this.initDone) {
                                this.initLoaders();
                            }
                            for (int i = 0; i < this.jarList.length; ++i) {
                                jl = this.jarList[i];
                                Class c = jl.loadClassData(className, jvmClassName, resolve);
                                if (c == null) continue;
                                if (this.vs != null) {
                                    this.vs.println(MessageService.getTextMessage("C006", className, jl.getJarName()));
                                }
                                clazz = c;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 9] lbl31 : MonitorExitStatement: MONITOREXIT : var5_5
                                break block16;
                            }
                        }
                        updateLoader = null;
                        break block17;
                    }
                    catch (StandardException se) {
                        String string;
                        if (jl == null) {
                            string = null;
                            throw new ClassNotFoundException(MessageService.getTextMessage("C007", className, string, se));
                        }
                        string = jl.getJarName();
                        throw new ClassNotFoundException(MessageService.getTextMessage("C007", className, string, se));
                    }
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!unlockLoader) throw throwable;
                    this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                    throw throwable;
                }
            }
            Object var13_12 = null;
            if (!unlockLoader) return clazz;
            this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            return clazz;
        }
        Object var13_13 = null;
        if (!unlockLoader) return updateLoader;
        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
        return updateLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream getResourceAsStream(String name) {
        UpdateLoader updateLoader;
        InputStream is;
        InputStream inputStream = is = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(name) : this.myLoader.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        if (name.endsWith(".class")) {
            return null;
        }
        boolean unlockLoader = false;
        try {
            try {
                unlockLoader = this.lockClassLoader(ShExQual.SH);
                updateLoader = this;
                synchronized (updateLoader) {
                    if (this.needReload) {
                        this.reload();
                    }
                    if (!this.initDone) {
                        this.initLoaders();
                    }
                    for (int i = 0; i < this.jarList.length; ++i) {
                        JarLoader jl = this.jarList[i];
                        is = jl.getStream(name);
                        if (is == null) continue;
                        InputStream inputStream2 = is;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var4_4
                        Object var10_10 = null;
                        if (!unlockLoader) return inputStream2;
                        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                        return inputStream2;
                    }
                }
                updateLoader = null;
            }
            catch (StandardException se) {
                InputStream inputStream3 = null;
                Object var10_12 = null;
                if (!unlockLoader) return inputStream3;
                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
                return inputStream3;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!unlockLoader) throw throwable;
            this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            throw throwable;
        }
        Object var10_11 = null;
        if (!unlockLoader) return updateLoader;
        this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
        return updateLoader;
    }

    synchronized void modifyClasspath(String classpath) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        this.modifyJar(false);
        this.initializeFromClassPath(classpath);
    }

    synchronized void modifyJar(boolean reload) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        if (!this.initDone) {
            return;
        }
        this.close();
        if (reload) {
            this.initializeFromClassPath(this.thisClasspath);
        }
    }

    private boolean lockClassLoader(ShExQual qualifier) throws StandardException {
        if (this.lf == null) {
            return false;
        }
        ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        CompatibilitySpace lockSpace = null;
        if (cfc != null) {
            lockSpace = cfc.getLockSpace();
        }
        if (lockSpace == null) {
            lockSpace = this.compat;
        }
        LockOwner lockGroup = lockSpace.getOwner();
        this.lf.lockObject(lockSpace, lockGroup, this.classLoaderLock, qualifier, -2);
        return lockGroup == this;
    }

    Class checkLoaded(String className, boolean resolve) {
        for (int i = 0; i < this.jarList.length; ++i) {
            Class c = this.jarList[i].checkLoaded(className, resolve);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    void close() {
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].setInvalid();
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].initialize();
        }
        this.initDone = true;
    }

    int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
        PersistentSet ps = cfc.getPersistentSet();
        String classpath = PropertyUtil.getServiceProperty(ps, "derby.database.classpath");
        if (classpath == null) {
            classpath = "";
        }
        return classpath;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext cfc = (ClassFactoryContext)ContextService.getContextOrNull("ClassFactoryContext");
            this.jarReader = cfc.getJarReader();
        }
        return this.jarReader;
    }

    public boolean noWait() {
        return false;
    }
}

