/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class FromTable
extends ResultSetNode
implements Optimizable {
    Properties tableProperties;
    String correlationName;
    TableName corrTableName;
    int tableNumber;
    int level;
    int[] hashKeyColumns;
    int initialCapacity = -1;
    float loadFactor = -1.0f;
    int maxCapacity = -1;
    AccessPathImpl currentAccessPath;
    AccessPathImpl bestAccessPath;
    AccessPathImpl bestSortAvoidancePath;
    AccessPathImpl trulyTheBestAccessPath;
    private int joinStrategyNumber;
    protected String userSpecifiedJoinStrategy;
    protected CostEstimate bestCostEstimate;
    private FormatableBitSet refCols;
    private double perRowUsage = -1.0;
    private boolean considerSortAvoidancePath;
    private HashMap bestPlanMap;
    protected static final short REMOVE_PLAN = 0;
    protected static final short ADD_PLAN = 1;
    protected static final short LOAD_PLAN = 2;
    protected TableName origTableName;

    FromTable() {
    }

    public void init(Object correlationName, Object tableProperties) {
        this.correlationName = (String)correlationName;
        this.tableProperties = (Properties)tableProperties;
        this.tableNumber = -1;
        this.bestPlanMap = null;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        this.updateBestPlanMap((short)1, this);
        CostEstimate singleScanCost = this.estimateCost(predList, null, outerCost, optimizer, rowOrdering);
        this.getCostEstimate(optimizer);
        this.setCostEstimate(singleScanCost);
        this.optimizeSubqueries(this.getDataDictionary(), this.costEstimate.rowCount());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, predList, this.getCostEstimate(), outerCost);
        return this.getCostEstimate();
    }

    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList predList, RowOrdering rowOrdering) throws StandardException {
        int numStrat = optimizer.getNumberOfJoinStrategies();
        boolean found = false;
        AccessPath ap = this.getCurrentAccessPath();
        if (this.userSpecifiedJoinStrategy != null) {
            if (ap.getJoinStrategy() != null) {
                ap.setJoinStrategy(null);
                found = false;
            } else {
                ap.setJoinStrategy(optimizer.getJoinStrategy(this.userSpecifiedJoinStrategy));
                if (ap.getJoinStrategy() == null) {
                    throw StandardException.newException("42Y56", (Object)this.userSpecifiedJoinStrategy, (Object)this.getBaseTableName());
                }
                found = true;
            }
        } else if (this.joinStrategyNumber < numStrat) {
            ap.setJoinStrategy(optimizer.getJoinStrategy(this.joinStrategyNumber));
            ++this.joinStrategyNumber;
            found = true;
            optimizer.trace(28, this.tableNumber, 0, 0.0, ap.getJoinStrategy());
        }
        this.tellRowOrderingAboutConstantColumns(rowOrdering, predList);
        return found;
    }

    protected boolean canBeOrdered() {
        return false;
    }

    public AccessPath getCurrentAccessPath() {
        return this.currentAccessPath;
    }

    public AccessPath getBestAccessPath() {
        return this.bestAccessPath;
    }

    public AccessPath getBestSortAvoidancePath() {
        return this.bestSortAvoidancePath;
    }

    public AccessPath getTrulyTheBestAccessPath() {
        return this.trulyTheBestAccessPath;
    }

    public void rememberSortAvoidancePath() {
        this.considerSortAvoidancePath = true;
    }

    public boolean considerSortAvoidancePath() {
        return this.considerSortAvoidancePath;
    }

    public void rememberJoinStrategyAsBest(AccessPath ap) {
        Optimizer optimizer = ap.getOptimizer();
        ap.setJoinStrategy(this.getCurrentAccessPath().getJoinStrategy());
        optimizer.trace(49, this.tableNumber, 0, 0.0, this.getCurrentAccessPath().getJoinStrategy());
        if (ap == this.bestAccessPath) {
            optimizer.trace(50, this.tableNumber, 0, 0.0, ap);
        } else if (ap == this.bestSortAvoidancePath) {
            optimizer.trace(51, this.tableNumber, 0, 0.0, ap);
        } else {
            optimizer.trace(52, this.tableNumber, 0, 0.0, ap);
        }
    }

    public TableDescriptor getTableDescriptor() {
        SanityManager.THROWASSERT("getTableDescriptor() not expected to be called for " + this.getClass().toString());
        return null;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
    }

    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        return this;
    }

    public boolean isCoveringIndex(ConglomerateDescriptor cd) throws StandardException {
        return false;
    }

    public Properties getProperties() {
        return this.tableProperties;
    }

    public void setProperties(Properties tableProperties) {
        this.tableProperties = tableProperties;
    }

    public void verifyProperties(DataDictionary dDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        boolean indexSpecified = false;
        Enumeration<Object> e = this.tableProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.tableProperties.get(key);
            if (key.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(value);
                continue;
            }
            if (key.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(value, key);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (key.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.valueOf(value).floatValue();
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("42Y58", (Object)value, (Object)key);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", value);
            }
            if (key.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(value, key);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            throw StandardException.newException("42Y44", (Object)key, (Object)"joinStrategy");
        }
    }

    public String getName() throws StandardException {
        return this.getExposedName();
    }

    public String getBaseTableName() {
        return "";
    }

    public int convertAbsoluteToRelativeColumnPosition(int absolutePosition) {
        return absolutePosition;
    }

    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        if (action == 0) {
            if (this.bestPlanMap != null) {
                this.bestPlanMap.remove(planKey);
                if (this.bestPlanMap.size() == 0) {
                    this.bestPlanMap = null;
                }
            }
            return;
        }
        AccessPath bestPath = this.getTrulyTheBestAccessPath();
        AccessPathImpl ap = null;
        if (action == 1) {
            if (bestPath == null) {
                return;
            }
            if (this.bestPlanMap == null) {
                this.bestPlanMap = new HashMap();
            } else {
                ap = (AccessPathImpl)this.bestPlanMap.get(planKey);
            }
            if (ap == null) {
                ap = planKey instanceof Optimizer ? new AccessPathImpl((Optimizer)planKey) : new AccessPathImpl(null);
            }
            ap.copy(bestPath);
            this.bestPlanMap.put(planKey, ap);
            return;
        }
        if (this.bestPlanMap == null) {
            return;
        }
        ap = (AccessPathImpl)this.bestPlanMap.get(planKey);
        if (ap == null || ap.getCostEstimate() == null) {
            return;
        }
        bestPath.copy(ap);
    }

    public void rememberAsBest(int planType, Optimizer optimizer) throws StandardException {
        AccessPath bestPath = null;
        switch (planType) {
            case 1: {
                bestPath = this.getBestAccessPath();
                break;
            }
            case 2: {
                bestPath = this.getBestSortAvoidancePath();
                break;
            }
            default: {
                SanityManager.THROWASSERT("Invalid plan type " + planType);
            }
        }
        this.getTrulyTheBestAccessPath().copy(bestPath);
        if (!(this instanceof ProjectRestrictNode)) {
            this.updateBestPlanMap((short)1, optimizer);
        } else {
            ProjectRestrictNode prn = (ProjectRestrictNode)this;
            if (!(prn.getChildResult() instanceof Optimizable)) {
                this.updateBestPlanMap((short)1, optimizer);
            }
        }
        ConglomerateDescriptor cd = bestPath.getConglomerateDescriptor();
        if (this.isBaseTable()) {
            DataDictionary dd = this.getDataDictionary();
            TableDescriptor td = this.getTableDescriptor();
            this.getTrulyTheBestAccessPath().initializeAccessPathName(dd, td);
        }
        this.setCostEstimate(bestPath.getCostEstimate());
        bestPath.getOptimizer().trace(29, this.tableNumber, planType, 0.0, bestPath);
    }

    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        this.resetJoinStrategies(optimizer);
        this.considerSortAvoidancePath = false;
        CostEstimate ce = this.getBestAccessPath().getCostEstimate();
        if (ce != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if ((ce = this.getBestSortAvoidancePath().getCostEstimate()) != null) {
            ce.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (!this.canBeOrdered()) {
            rowOrdering.addUnorderedOptimizable(this);
        }
    }

    protected void resetJoinStrategies(Optimizer optimizer) {
        this.joinStrategyNumber = 0;
        this.getCurrentAccessPath().setJoinStrategy(null);
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        SanityManager.THROWASSERT("estimateCost() not expected to be called for " + this.getClass().toString());
        return null;
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getTrulyTheBestAccessPath() == null ? this.costEstimate : this.getTrulyTheBestAccessPath().getCostEstimate();
        return this.finalCostEstimate;
    }

    public boolean isBaseTable() {
        return false;
    }

    public boolean isMaterializable() throws StandardException {
        HasCorrelatedCRsVisitor visitor = new HasCorrelatedCRsVisitor();
        this.accept(visitor);
        return !visitor.hasCorrelatedCRs();
    }

    public boolean supportsMultipleInstantiations() {
        return true;
    }

    public int getTableNumber() {
        return this.tableNumber;
    }

    public boolean hasTableNumber() {
        return this.tableNumber >= 0;
    }

    public boolean forUpdate() {
        return false;
    }

    public int initialCapacity() {
        SanityManager.THROWASSERT("Not expected to be called");
        return 0;
    }

    public float loadFactor() {
        SanityManager.THROWASSERT("Not expected to be called");
        return 0.0f;
    }

    public int maxCapacity(JoinStrategy joinStrategy, int maxMemoryPerTable) throws StandardException {
        return joinStrategy.maxCapacity(this.maxCapacity, maxMemoryPerTable, this.getPerRowUsage());
    }

    private double getPerRowUsage() throws StandardException {
        if (this.perRowUsage < 0.0) {
            FormatableBitSet refCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
            this.perRowUsage = 0.0;
            for (int i = 0; i < refCols.size(); ++i) {
                ResultColumn rc;
                DataTypeDescriptor expressionType;
                if (!refCols.isSet(i) || (expressionType = (rc = (ResultColumn)this.resultColumns.elementAt(i)).getExpression().getTypeServices()) == null) continue;
                this.perRowUsage += expressionType.estimatedMemoryUsage();
            }
            ConglomerateDescriptor cd = this.getCurrentAccessPath().getConglomerateDescriptor();
            if (cd != null && cd.isIndex() && !this.isCoveringIndex(cd)) {
                this.perRowUsage += 12.0;
            }
        }
        return this.perRowUsage;
    }

    public int[] hashKeyColumns() {
        SanityManager.ASSERT(this.hashKeyColumns != null, "hashKeyColumns expected to be non-null");
        return this.hashKeyColumns;
    }

    public void setHashKeyColumns(int[] columnNumbers) {
        this.hashKeyColumns = columnNumbers;
    }

    public boolean feasibleJoinStrategy(OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        return this.getCurrentAccessPath().getJoinStrategy().feasible(this, predList, optimizer);
    }

    public boolean memoryUsageOK(double rowCount, int maxMemoryPerTable) throws StandardException {
        if (this.userSpecifiedJoinStrategy != null) {
            return true;
        }
        int intRowCount = rowCount > 2.147483647E9 ? Integer.MAX_VALUE : (int)rowCount;
        return intRowCount <= this.maxCapacity(this.getCurrentAccessPath().getJoinStrategy(), maxMemoryPerTable);
    }

    public boolean legalJoinOrder(JBitSet assignedTableMap) {
        return true;
    }

    public int getNumColumnsReturned() {
        return this.resultColumns.size();
    }

    public boolean isTargetTable() {
        return false;
    }

    public boolean isOneRowScan() throws StandardException {
        return this.isOneRowResultSet();
    }

    public void initAccessPaths(Optimizer optimizer) {
        if (this.currentAccessPath == null) {
            this.currentAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestAccessPath == null) {
            this.bestAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestSortAvoidancePath == null) {
            this.bestSortAvoidancePath = new AccessPathImpl(optimizer);
        }
        if (this.trulyTheBestAccessPath == null) {
            this.trulyTheBestAccessPath = new AccessPathImpl(optimizer);
        }
    }

    public double uniqueJoin(OptimizablePredicateList predList) throws StandardException {
        return -1.0;
    }

    private FormatableBitSet getRefCols() {
        if (this.refCols == null) {
            this.refCols = this.resultColumns.getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
        }
        return this.refCols;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.tableProperties == null) {
            return null;
        }
        return this.tableProperties.getProperty("joinStrategy");
    }

    protected boolean cursorTargetTable() {
        return false;
    }

    protected CostEstimate getCostEstimate(Optimizer optimizer) {
        if (this.costEstimate == null) {
            this.costEstimate = optimizer.newCostEstimate();
        }
        return this.costEstimate;
    }

    protected CostEstimate getScratchCostEstimate(Optimizer optimizer) {
        if (this.scratchCostEstimate == null) {
            this.scratchCostEstimate = optimizer.newCostEstimate();
        }
        return this.scratchCostEstimate;
    }

    protected void setCostEstimate(CostEstimate newCostEstimate) {
        this.costEstimate = this.getCostEstimate();
        this.costEstimate.setCost(newCostEstimate);
    }

    protected void assignCostEstimate(CostEstimate newCostEstimate) {
        this.costEstimate = newCostEstimate;
    }

    public String toString() {
        return "correlation Name: " + this.correlationName + "\n" + (this.corrTableName != null ? this.corrTableName.toString() : "null") + "\n" + "tableNumber " + this.tableNumber + "\n" + "level " + this.level + "\n" + super.toString();
    }

    public ResultColumnList getResultColumnsForList(TableName allTableName, ResultColumnList inputRcl, TableName tableName) throws StandardException {
        ResultColumnList rcList = null;
        TableName toCompare = this.correlationName == null ? tableName : (allTableName != null ? this.makeTableName(allTableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName));
        if (allTableName != null && !allTableName.equals(toCompare)) {
            return null;
        }
        TableName exposedName = this.correlationName == null ? tableName : this.makeTableName(null, this.correlationName);
        rcList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int inputSize = inputRcl.size();
        for (int index = 0; index < inputSize; ++index) {
            String columnName = ((ResultColumn)inputRcl.elementAt(index)).getName();
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(62, columnName, exposedName, this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, valueNode, this.getContextManager());
            rcList.addResultColumn(resultColumn);
        }
        return rcList;
    }

    void pushExpressions(PredicateList predicateList) throws StandardException {
        SanityManager.ASSERT(predicateList != null, "predicateList is expected to be non-null");
    }

    public String getExposedName() throws StandardException {
        SanityManager.THROWASSERT("getExposedName() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public void setTableNumber(int tableNumber) {
        SanityManager.ASSERT(this.tableNumber == -1, "tableNumber is not expected to be already set");
        this.tableNumber = tableNumber;
    }

    public TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    void decrementLevel(int decrement) {
        if (this.level < decrement && this.level != 0) {
            SanityManager.THROWASSERT("level (" + this.level + ") expected to be >= decrement (" + decrement + ")");
        }
        if (this.level > 0) {
            this.level -= decrement;
        }
    }

    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(this.corrTableName);
    }

    public SchemaDescriptor getSchemaDescriptor(TableName tableName) throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(tableName.getSchemaName());
        return sd;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        if (schemaName != null) {
            return null;
        }
        if (this.getExposedName().equals(name)) {
            return this;
        }
        return null;
    }

    public boolean isFlattenableJoinNode() {
        return false;
    }

    public boolean LOJ_reorderable(int numTables) throws StandardException {
        return false;
    }

    public FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        return this;
    }

    public void fillInReferencedTableMap(JBitSet passedMap) {
        if (this.tableNumber != -1) {
            passedMap.set(this.tableNumber);
        }
    }

    protected void markUpdatableByCursor(Vector updateColumns) {
        this.resultColumns.markUpdatableByCursor(updateColumns);
    }

    public FromList flatten(ResultColumnList rcl, PredicateList outerPList, SubqueryList sql, GroupByList gbl) throws StandardException {
        SanityManager.THROWASSERT("flatten() not expected to be called for " + this);
        return null;
    }

    void optimizeSubqueries(DataDictionary dd, double rowCount) throws StandardException {
    }

    protected void tellRowOrderingAboutConstantColumns(RowOrdering rowOrdering, OptimizablePredicateList predList) {
        if (predList != null) {
            for (int i = 0; i < predList.size(); ++i) {
                ColumnReference cr;
                Predicate pred = (Predicate)predList.getOptPredicate(i);
                if (!pred.equalsComparisonWithConstantExpression(this) || (cr = pred.getRelop().getColumnOperand(this)) == null) continue;
                rowOrdering.columnAlwaysOrdered(this, cr.getColumnNumber());
            }
        }
    }

    public boolean needsSpecialRCLBinding() {
        return false;
    }

    public void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    public TableName getOrigTableName() {
        return this.origTableName;
    }
}

