/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.IsNullNode;
import org.apache.derby.impl.sql.compile.JavaValueNode;
import org.apache.derby.impl.sql.compile.NotNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ReferencedTablesVisitor;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.SubqueryList;

public abstract class ValueNode
extends QueryTreeNode {
    private DataTypeDescriptor dataTypeServices;
    boolean transformed;

    public ValueNode() {
    }

    final void setType(TypeId typeId, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, isNullable, maximumWidth));
    }

    final void setType(TypeId typeId, int precision, int scale, boolean isNullable, int maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor(typeId, precision, scale, isNullable, maximumWidth));
    }

    public void init(Object typeId, Object precision, Object scale, Object isNullable, Object maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)typeId, (int)((Integer)precision), (int)((Integer)scale), (boolean)((Boolean)isNullable), (int)((Integer)maximumWidth)));
    }

    ValueNode(Object tcf, Object typeId, Object isNullable, Object maximumWidth) throws StandardException {
        this.setType(new DataTypeDescriptor((TypeId)typeId, (boolean)((Boolean)isNullable), (int)((Integer)maximumWidth)));
    }

    public String toString() {
        return "dataTypeServices: " + (this.dataTypeServices != null ? this.dataTypeServices.toString() : "null") + "\n" + super.toString();
    }

    public DataTypeDescriptor getTypeServices() {
        return this.dataTypeServices;
    }

    public void setNullability(boolean nullability) throws StandardException {
        this.setType(this.getTypeServices().getNullabilityType(nullability));
    }

    public void setCollationInfo(DataTypeDescriptor collationInfoType) throws StandardException {
        this.setCollationInfo(collationInfoType.getCollationType(), collationInfoType.getCollationDerivation());
    }

    public void setCollationInfo(int collationType, int collationDerivation) throws StandardException {
        this.setType(this.getTypeServices().getCollatedType(collationType, collationDerivation));
    }

    public TypeId getTypeId() throws StandardException {
        DataTypeDescriptor dtd = this.getTypeServices();
        if (dtd != null) {
            return dtd.getTypeId();
        }
        return null;
    }

    protected final DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public final TypeCompiler getTypeCompiler() throws StandardException {
        return this.getTypeCompiler(this.getTypeId());
    }

    public void setType(DataTypeDescriptor dataTypeServices) throws StandardException {
        this.dataTypeServices = dataTypeServices;
    }

    protected final void setCollationUsingCompilationSchema() throws StandardException {
        this.setCollationUsingCompilationSchema(1);
    }

    protected final void setCollationUsingCompilationSchema(int collationDerivation) throws StandardException {
        this.setCollationInfo(this.getSchemaDescriptor(null, false).getCollationType(), collationDerivation);
    }

    public ResultColumn getSourceResultColumn() {
        return null;
    }

    void setTransformed() {
        this.transformed = true;
    }

    boolean getTransformed() {
        return this.transformed;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        return this.bindExpression(fromList, subqueryList, aggregateVector, false);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector, boolean forQueryRewrite) throws StandardException {
        SanityManager.ASSERT(false, "bindExpression() not expected to be called on a " + this.getClass().toString());
        return this;
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        SanityManager.ASSERT(this.getTypeId() != null, "genSQLJavaSQLTree() only expected to be called on a bound node");
        SanityManager.ASSERT(this.getTypeId().userType(), "genSQLJavaSQLTree() only expected to be called on user types");
        JavaValueNode stjvn = (JavaValueNode)this.getNodeFactory().getNode(28, this, this.getContextManager());
        ValueNode jtsvn = (ValueNode)this.getNodeFactory().getNode(36, stjvn, this.getContextManager());
        jtsvn.setType(DataTypeDescriptor.getSQLDataTypeDescriptor(stjvn.getJavaTypeName()));
        return jtsvn;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        return this;
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (!underNotNode) {
            return this;
        }
        SanityManager.ASSERT(this.getTypeId().isBooleanTypeId(), "Node's type (" + this.getTypeId().getSQLTypeName() + ") is expected to be boolean");
        return this.genEqualsFalseTree();
    }

    public ValueNode genEqualsFalseTree() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        BooleanConstantNode falseNode = (BooleanConstantNode)nodeFactory.getNode(38, Boolean.FALSE, this.getContextManager());
        BinaryRelationalOperatorNode equalsNode = (BinaryRelationalOperatorNode)nodeFactory.getNode(41, this, falseNode, this.getContextManager());
        boolean nullableResult = this.getTypeServices().isNullable();
        equalsNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
        return equalsNode;
    }

    public ValueNode genIsNullTree() throws StandardException {
        IsNullNode isNullNode = (IsNullNode)this.getNodeFactory().getNode(25, this, this.getContextManager());
        isNullNode.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, false));
        return isNullNode;
    }

    boolean verifyEliminateNots() {
        return !(this instanceof NotNode);
    }

    public ValueNode putAndsOnTop() throws StandardException {
        NodeFactory nodeFactory = this.getNodeFactory();
        QueryTreeNode trueNode = nodeFactory.getNode(38, Boolean.TRUE, this.getContextManager());
        AndNode andNode = (AndNode)nodeFactory.getNode(39, this, trueNode, this.getContextManager());
        andNode.postBindFixup();
        return andNode;
    }

    public boolean verifyPutAndsOnTop() {
        return true;
    }

    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        return this;
    }

    public boolean verifyChangeToCNF() {
        return true;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return true;
    }

    public String getSchemaName() throws StandardException {
        return null;
    }

    public String getTableName() {
        return null;
    }

    public boolean updatableByCursor() {
        return false;
    }

    public String getColumnName() {
        return null;
    }

    JBitSet getTablesReferenced() throws StandardException {
        ReferencedTablesVisitor rtv = new ReferencedTablesVisitor(new JBitSet(0));
        this.accept(rtv);
        return rtv.getTableMap();
    }

    public boolean isCloneable() {
        return false;
    }

    public ValueNode getClone() throws StandardException {
        SanityManager.ASSERT(false, "getClone() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public void copyFields(ValueNode oldVN) throws StandardException {
        this.dataTypeServices = oldVN.getTypeServices();
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        return this;
    }

    public boolean isConstantExpression() {
        return false;
    }

    public boolean constantExpression(PredicateList whereClause) {
        return false;
    }

    protected int getOrderableVariantType() throws StandardException {
        return 0;
    }

    public ValueNode checkIsBoolean() throws StandardException {
        ValueNode whereClause = this;
        TypeId whereTypeId = whereClause.getTypeId();
        if (whereTypeId.userType()) {
            whereClause = whereClause.genSQLJavaSQLTree();
            whereTypeId = whereClause.getTypeId();
        }
        if (!whereTypeId.equals(TypeId.BOOLEAN_ID)) {
            throw StandardException.newException("42X19", whereTypeId.getSQLTypeName());
        }
        return whereClause;
    }

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    protected final void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateExpression(acb, mb);
    }

    public void generateFilter(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        this.generateExpression(ecb, mb);
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        if (this.transformed) {
            return 1.0;
        }
        return 0.5;
    }

    void checkTopPredicatesForEqualsConditions(int tableNumber, boolean[] eqOuterCols, int[] tableNumbers, JBitSet[] tableColMap, boolean resultColTable) throws StandardException {
        ValueNode whereWalker = this;
        while (whereWalker instanceof AndNode) {
            AndNode and = (AndNode)whereWalker;
            if (and.getLeftOperand().isRelationalOperator() && ((RelationalOperator)((Object)and.getLeftOperand())).getOperator() == 1) {
                int resultTable;
                BinaryRelationalOperatorNode beon = (BinaryRelationalOperatorNode)and.getLeftOperand();
                ValueNode left = beon.getLeftOperand();
                ValueNode right = beon.getRightOperand();
                if (resultColTable) {
                    for (resultTable = 0; resultTable < tableNumbers.length && tableNumbers[resultTable] != tableNumber; ++resultTable) {
                    }
                } else {
                    resultTable = -1;
                }
                if (left instanceof ColumnReference && ((ColumnReference)left).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, right, left);
                } else if (right instanceof ColumnReference && ((ColumnReference)right).getTableNumber() == tableNumber) {
                    this.updateMaps(tableColMap, eqOuterCols, tableNumbers, tableNumber, resultTable, left, right);
                }
            }
            whereWalker = ((AndNode)whereWalker).getRightOperand();
        }
    }

    boolean isBooleanTrue() {
        return false;
    }

    boolean isBooleanFalse() {
        return false;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(false, "Code generation for this type of ValueNode is unimplemented");
    }

    private void updateMaps(JBitSet[] tableColMap, boolean[] eqOuterCols, int[] tableNumbers, int tableNumber, int resultTable, ValueNode arg1, ValueNode arg2) throws StandardException {
        if (arg1 instanceof ConstantNode || arg1.requiresTypeFromContext()) {
            this.setValueCols(tableColMap, eqOuterCols, ((ColumnReference)arg2).getColumnNumber(), resultTable);
        } else if (arg1 instanceof ColumnReference && ((ColumnReference)arg1).getTableNumber() != tableNumber) {
            int index;
            int otherTN = ((ColumnReference)arg1).getTableNumber();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && otherTN != tableNumbers[index]; ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null) {
                tableColMap[index].set(colNumber);
            }
        } else {
            int index;
            JBitSet referencedTables = arg1.getTablesReferenced();
            int colNumber = ((ColumnReference)arg2).getColumnNumber();
            for (index = 0; index < tableNumbers.length && !referencedTables.get(tableNumbers[index]); ++index) {
            }
            if (index == tableNumbers.length) {
                this.setValueCols(tableColMap, eqOuterCols, colNumber, resultTable);
            } else if (tableColMap != null && !referencedTables.get(tableNumber)) {
                tableColMap[index].set(colNumber);
            }
        }
    }

    private void setValueCols(JBitSet[] tableColMap, boolean[] eqOuterCols, int colReference, int resultTable) {
        if (eqOuterCols != null) {
            eqOuterCols[colReference] = true;
        }
        if (tableColMap != null) {
            if (resultTable == -1) {
                for (int i = 0; i < tableColMap.length; ++i) {
                    tableColMap[i].set(colReference);
                }
            } else {
                tableColMap[resultTable].set(colReference);
            }
        }
    }

    public boolean isRelationalOperator() {
        return false;
    }

    public boolean isBinaryEqualsOperatorNode() {
        return false;
    }

    public boolean isInListProbeNode() {
        return false;
    }

    public boolean optimizableEqualityNode(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        return false;
    }

    public boolean requiresTypeFromContext() {
        return false;
    }

    public boolean isParameterNode() {
        return false;
    }

    protected abstract boolean isEquivalent(ValueNode var1) throws StandardException;

    protected final boolean isSameNodeType(ValueNode other) {
        if (other != null) {
            return other.getNodeType() == this.getNodeType();
        }
        return false;
    }
}

