/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.SpaceInfo;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.BTree;
import org.apache.derby.impl.store.access.btree.BTreeLockingPolicy;
import org.apache.derby.impl.store.access.btree.BTreeRowPosition;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.LeafControlRow;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerateScratchSpace;

public class OpenBTree {
    private BTree init_conglomerate;
    private TransactionManager init_xact_manager;
    private Transaction init_rawtran;
    private int init_openmode;
    protected int init_lock_level;
    private DynamicCompiledOpenConglomInfo init_dynamic_info;
    private boolean init_hold;
    private BTreeLockingPolicy init_btree_locking_policy;
    protected ContainerHandle container;
    protected long err_containerid;
    protected TransactionManager init_open_user_scans = null;
    protected LogicalUndo btree_undo = null;
    protected OpenConglomerateScratchSpace runtime_mem;

    public final TransactionManager getXactMgr() {
        return this.init_xact_manager;
    }

    public final Transaction getRawTran() {
        return this.init_rawtran;
    }

    public final int getLockLevel() {
        return this.init_lock_level;
    }

    public final ContainerHandle getContainer() {
        return this.container;
    }

    public final int getOpenMode() {
        return this.init_openmode;
    }

    public final BTree getConglomerate() {
        return this.init_conglomerate;
    }

    public final boolean getHold() {
        return this.init_hold;
    }

    public final BTreeLockingPolicy getLockingPolicy() {
        return this.init_btree_locking_policy;
    }

    public final void setLockingPolicy(BTreeLockingPolicy policy) {
        this.init_btree_locking_policy = policy;
    }

    public final boolean isClosed() {
        return this.container == null;
    }

    public final OpenConglomerateScratchSpace getRuntimeMem() {
        return this.runtime_mem;
    }

    public long getEstimatedRowCount() throws StandardException {
        long row_count;
        if (this.container == null) {
            this.reopen();
        }
        return (row_count = this.container.getEstimatedRowCount(0)) == 0L ? 1L : row_count;
    }

    public void setEstimatedRowCount(long count) throws StandardException {
        if (this.container == null) {
            this.reopen();
        }
        this.container.setEstimatedRowCount(count, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConsistency() throws StandardException {
        ControlRow root = null;
        try {
            if (this.container == null) {
                throw StandardException.newException("XSCB8.S", new Long(this.err_containerid));
            }
            SanityManager.ASSERT(this.init_conglomerate.format_ids != null);
            root = ControlRow.get(this, 1L);
            int n = root.checkConsistency(this, null, true);
        }
        finally {
            if (root != null) {
                root.release();
            }
        }
    }

    public boolean isTableLocked() {
        return this.init_lock_level == 7;
    }

    public void init(TransactionManager open_user_scans, TransactionManager xact_manager, ContainerHandle input_container, Transaction rawtran, boolean hold, int open_mode, int lock_level, BTreeLockingPolicy btree_locking_policy, BTree conglomerate, LogicalUndo undo, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        if (this.container != null) {
            SanityManager.ASSERT(false, "why is the container open?");
            this.close();
        }
        this.err_containerid = conglomerate.id.getContainerId();
        this.init_btree_locking_policy = btree_locking_policy;
        if (conglomerate.isTemporary()) {
            open_mode |= 0x800;
        }
        this.container = input_container == null ? rawtran.openContainer(conglomerate.id, null, open_mode) : input_container;
        if (this.container == null) {
            throw StandardException.newException("XSCB1.S", new Long(this.err_containerid));
        }
        this.init_conglomerate = conglomerate;
        this.init_xact_manager = xact_manager;
        this.init_rawtran = rawtran;
        this.init_openmode = open_mode;
        this.init_lock_level = lock_level;
        this.init_dynamic_info = dynamic_info;
        this.init_hold = hold;
        this.init_open_user_scans = open_user_scans;
        this.btree_undo = undo;
        this.runtime_mem = dynamic_info != null ? (OpenConglomerateScratchSpace)dynamic_info : new OpenConglomerateScratchSpace(conglomerate.format_ids, conglomerate.collation_ids);
    }

    public ContainerHandle reopen() throws StandardException {
        SanityManager.ASSERT(this.init_xact_manager != null);
        SanityManager.ASSERT(this.init_xact_manager.getRawStoreXact() != null);
        SanityManager.ASSERT(this.init_conglomerate != null);
        if (this.container == null) {
            this.container = this.init_xact_manager.getRawStoreXact().openContainer(this.init_conglomerate.id, null, this.init_openmode);
        }
        return this.container;
    }

    public void close() throws StandardException {
        if (this.container != null) {
            this.container.close();
        }
        this.container = null;
    }

    void isIndexableRowConsistent(DataValueDescriptor[] row) throws StandardException {
        DataValueDescriptor[] template = this.init_conglomerate.createTemplate(this.getRawTran());
        for (int i = 0; i < row.length; ++i) {
            if (row[i].getClass().equals(template[i].getClass())) continue;
            SanityManager.THROWASSERT("type of inserted column[" + i + "] = " + row[i].getClass().getName() + "type of template column[" + i + "] = " + template[i].getClass().getName());
        }
    }

    public ContainerHandle getContainerHandle() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() throws StandardException {
        ControlRow root = null;
        try {
            int height;
            root = ControlRow.get(this, 1L);
            int n = height = root.getLevel() + 1;
            return n;
        }
        finally {
            if (root != null) {
                root.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugConglomerate() throws StandardException {
        ControlRow root = null;
        try {
            SanityManager.DEBUG_PRINT("p_tree", "BTREE Dump: containerId " + this.container.getId());
            SanityManager.DEBUG_PRINT("p_tree", "BTREE Dump: btree " + this.init_conglomerate);
            root = ControlRow.get(this, 1L);
            root.printTree(this);
        }
        finally {
            if (root != null) {
                root.release();
            }
        }
    }

    public static boolean test_errors(OpenBTree open_btree, String debug_string, BTreeRowPosition pos, BTreeLockingPolicy btree_locking_policy, LeafControlRow leaf, boolean input_latch_released) throws StandardException {
        String debug_deadlock;
        boolean latch_released = input_latch_released;
        String debug_lost_latch = debug_string + "1";
        if (SanityManager.DEBUG_ON(debug_lost_latch) && !latch_released) {
            if (pos != null) {
                SanityManager.ASSERT(pos.current_leaf == leaf);
                pos.saveMeAndReleasePage();
            } else {
                leaf.release();
            }
            latch_released = true;
            SanityManager.DEBUG_PRINT(debug_lost_latch, debug_lost_latch);
            SanityManager.DEBUG_CLEAR(debug_lost_latch);
        }
        if (SanityManager.DEBUG_ON(debug_deadlock = debug_string + "2")) {
            SanityManager.DEBUG_PRINT(debug_deadlock, debug_deadlock);
            SanityManager.DEBUG_CLEAR(debug_deadlock);
            StandardException se = StandardException.newException("40001", (Object)"fake deadlock", (Object)"fake victim");
            se.setReport(2);
            throw se;
        }
        return latch_released;
    }

    public SpaceInfo getSpaceInfo() throws StandardException {
        return this.container.getSpaceInfo();
    }

    public boolean[] getColumnSortOrderInfo() throws StandardException {
        return this.init_conglomerate.ascDescInfo;
    }
}

