/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.HashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkCacheKey;

public class UnitOfWorkIdentityMap
extends FullIdentityMap {
    public UnitOfWorkIdentityMap(int size, ClassDescriptor descriptor) {
        this.maxSize = size;
        this.cacheKeys = new HashMap(size);
        this.descriptor = descriptor;
    }

    public UnitOfWorkIdentityMap(int size, ClassDescriptor descriptor, boolean isolated) {
        this(size, descriptor);
        this.isIsolated = isolated;
    }

    public CacheKey createCacheKey(Object primaryKey, Object object, Object writeLockValue, long readTime) {
        return new UnitOfWorkCacheKey(primaryKey, object, writeLockValue, readTime, this.isIsolated);
    }

    public CacheKey acquireDeferredLock(Object primaryKey) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, false);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireLock(Object primaryKey, boolean forMerge) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireLockNoWait(Object primaryKey, boolean forMerge) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireLockWithWait(Object primaryKey, boolean forMerge, int wait) {
        CacheKey newCacheKey;
        CacheKey cacheKey = this.getCacheKey(primaryKey, forMerge);
        if (cacheKey == null && (cacheKey = this.putCacheKeyIfAbsent(newCacheKey = this.createCacheKey(primaryKey, null, null))) == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    public CacheKey acquireReadLockOnCacheKey(Object primaryKey) {
        return this.acquireReadLockOnCacheKeyNoWait(primaryKey);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey) {
        CacheKey newCacheKey = this.createCacheKey(primaryKey, null, null);
        CacheKey cacheKey = this.getCacheKey(newCacheKey, false);
        if (cacheKey == null) {
            return newCacheKey;
        }
        return cacheKey;
    }

    protected CacheKey getCacheKeyWithReadLock(Object primaryKey) {
        return this.getCacheKey(primaryKey, false);
    }

    protected CacheKey putCacheKeyIfAbsent(CacheKey searchKey) {
        searchKey.setOwningMap(this);
        this.cacheKeys.put(searchKey.getKey(), searchKey);
        return null;
    }

    public Object remove(CacheKey cacheKey) {
        if (cacheKey == null) {
            return null;
        }
        this.cacheKeys.remove(cacheKey.getKey());
        cacheKey.setOwningMap(null);
        return cacheKey.getObject();
    }

    public void resetCacheKey(CacheKey key, Object object, Object writeLockValue, long readTime) {
        key.setObject(object);
        key.setWriteLockValue(writeLockValue);
        key.setReadTime(readTime);
    }

    public void setWriteLockValue(Object primaryKey, Object writeLockValue) {
        CacheKey cacheKey = this.getCacheKeyForLock(primaryKey);
        if (cacheKey != null) {
            cacheKey.setWriteLockValue(writeLockValue);
        }
    }
}

