/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParserFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.JPAQueryBuilder;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public final class ANTLRQueryBuilder
implements JPAQueryBuilder {
    private JPQLParseTree buildParseTree(CharSequence jpqlQuery, AbstractSession session) {
        JPQLParseTree parseTree = JPQLParser.buildParseTree(jpqlQuery.toString());
        parseTree.setClassLoader(session.getDatasourcePlatform().getConversionManager().getLoader());
        return parseTree;
    }

    public DatabaseQuery buildQuery(CharSequence jpqlQuery, AbstractSession session) {
        JPQLParseTree parseTree = this.buildParseTree(jpqlQuery, session);
        DatabaseQuery databaseQuery = parseTree.createDatabaseQuery();
        databaseQuery.setJPQLString(jpqlQuery.toString());
        this.populateQueryInternal(session, parseTree, databaseQuery);
        return databaseQuery;
    }

    public Expression buildSelectionCriteria(String entityName, String additionalCriteria, AbstractSession session) {
        StringBuilder jpqlQuery = new StringBuilder();
        jpqlQuery.append("select this from ");
        jpqlQuery.append(entityName);
        jpqlQuery.append(" this where ");
        jpqlQuery.append(additionalCriteria.trim());
        return this.buildQuery(jpqlQuery, session).getSelectionCriteria();
    }

    public void populateQuery(CharSequence jpqlQuery, DatabaseQuery query, AbstractSession session) {
        new JPQLParserFactory().populateQuery(jpqlQuery.toString(), (ObjectLevelReadQuery)query, session);
    }

    private void populateQueryInternal(AbstractSession session, JPQLParseTree parseTree, DatabaseQuery databaseQuery) {
        parseTree.populateQuery(databaseQuery, session);
        parseTree.addParametersToQuery(databaseQuery);
    }
}

