/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.tables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTableMetadata
extends TableMetadata {
    private List<JoinColumnMetadata> m_joinColumns;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns;

    public CollectionTableMetadata() {
        super("<collection-table>");
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    }

    public CollectionTableMetadata(MetadataAccessor accessor) {
        super(null, accessor);
        this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
        this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    }

    public CollectionTableMetadata(MetadataAnnotation collectionTable, MetadataAccessor accessor, boolean isJPACollectionTable) {
        block4: {
            super(collectionTable, accessor);
            this.m_joinColumns = new ArrayList<JoinColumnMetadata>();
            this.m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
            if (collectionTable == null) break block4;
            if (isJPACollectionTable) {
                Object[] objectArray = (Object[])collectionTable.getAttributeArray("joinColumns");
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object joinColumn = objectArray[n2];
                    this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessor));
                    ++n2;
                }
            } else {
                Object[] objectArray = (Object[])collectionTable.getAttributeArray("primaryKeyJoinColumns");
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Object primaryKeyJoinColumn = objectArray[n3];
                    this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn, accessor));
                    ++n3;
                }
            }
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof CollectionTableMetadata) {
            CollectionTableMetadata collectionTable = (CollectionTableMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, collectionTable.getJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_primaryKeyJoinColumns, collectionTable.getPrimaryKeyJoinColumns());
        }
        return false;
    }

    @Override
    public String getCatalogContext() {
        return "metadata_default_collection_table_catalog";
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    @Override
    public String getNameContext() {
        return "metadata_default_collection_table_name";
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public String getSchemaContext() {
        return "metadata_default_collection_table_schema";
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

