/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.persistence.exceptions.JAXBException;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.reflection.AnnotationHelper;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaModelImpl
implements JavaModel {
    protected ClassLoader classLoader;
    private AnnotationHelper annotationHelper;
    private Map<String, Boolean> metadataCompletePackages;

    public JavaModelImpl(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.annotationHelper = new AnnotationHelper();
    }

    public JavaModelImpl(ClassLoader classLoader, AnnotationHelper annotationHelper) {
        this.classLoader = classLoader;
        this.annotationHelper = annotationHelper;
    }

    @Override
    public JavaClass getClass(Class<?> jClass) {
        try {
            JavaClassImpl javaClass = new JavaClassImpl(jClass, this);
            if (this.metadataCompletePackages != null && this.metadataCompletePackages.containsKey(javaClass.getPackageName())) {
                javaClass.setIsMetadataComplete(this.metadataCompletePackages.get(javaClass.getPackageName()));
            }
            if (this.classLoader instanceof JaxbClassLoader) {
                ((JaxbClassLoader)this.classLoader).putClass(jClass.getCanonicalName(), jClass);
            }
            return javaClass;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public JavaClass getClass(String className) {
        try {
            Class<?> clazz;
            if (className.contains("[") && (clazz = Class.forName(className)) != null) {
                return this.getClass(clazz);
            }
            clazz = this.classLoader.loadClass(className);
            return this.getClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw JAXBException.classNotFoundException((String)className);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Annotation getAnnotation(JavaAnnotation janno, Class<?> jClass) {
        return ((JavaAnnotationImpl)janno).getJavaAnnotation();
    }

    public AnnotationHelper getAnnotationHelper() {
        return this.annotationHelper;
    }

    public void setMetadataCompletePackageMap(Map<String, Boolean> metadataCompletePackageMap) {
        this.metadataCompletePackages = metadataCompletePackageMap;
    }
}

