/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.tests.junit;

import java.lang.reflect.Method;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingJUnit4ClassRunner
extends BlockJUnit4ClassRunner {
    static final Logger LOG = LoggerFactory.getLogger(LoggingJUnit4ClassRunner.class);

    public LoggingJUnit4ClassRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodInvoker(FrameworkMethod method, Object test) {
        return new LoggingStatemant(method.getMethod(), super.methodInvoker(method, test));
    }

    static class LoggingStatemant
    extends Statement {
        private final Method method;
        private final Statement delegate;

        public LoggingStatemant(Method method, Statement delegate) {
            this.method = method;
            this.delegate = delegate;
        }

        public void evaluate() throws Throwable {
            LOG.info("[JUnit] STARTING: {}#{}", (Object)this.method.getDeclaringClass().getSimpleName(), (Object)this.method.getName());
            try {
                this.delegate.evaluate();
            }
            catch (Throwable t) {
                LOG.info("[JUnit] FAILED: {}#{} ({})", new Object[]{this.method.getDeclaringClass().getSimpleName(), this.method.getName(), ExceptionUtils.getRootCauseMessage((Throwable)t), t});
                throw t;
            }
            LOG.info("[JUnit] FINISHED: {}#{}.", (Object)this.method.getDeclaringClass().getSimpleName(), (Object)this.method.getName());
        }
    }
}

