/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleManagerImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleStore;
import org.eclipse.gyrex.jobs.schedules.ISchedule;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.BackingStoreException;

public class SchedulesSection
extends ViewerWithButtonsSectionPart {
    private TreeViewer dataTree;
    private final DataBindingContext bindingContext;
    private Object selectedValue;
    private Button addButton;
    private Button removeButton;
    private Button enableButton;
    private Button disableButton;

    public SchedulesSection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Schedules");
        section.setDescription("Manage the available schedules.");
        this.createContent(section);
    }

    void addButtonPressed() {
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.removeButtonPressed();
            }
        });
        this.enableButton = this.createButton(buttonsPanel, "Enable", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.enableButtonPressed();
            }
        });
        this.disableButton = this.createButton(buttonsPanel, "Disable", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SchedulesSection.this.disableButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.dataTree = new TreeViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        Tree tree = this.dataTree.getTree();
        this.getToolkit().adapt((Control)tree, true, true);
        tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.dataTree.setContentProvider((IContentProvider)new ViewContentProvider());
        this.dataTree.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.dataTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    SchedulesSection.this.setSelectedValue(((IStructuredSelection)selection).getFirstElement());
                }
            }
        });
    }

    void disableButtonPressed() {
        if (this.selectedValue instanceof ScheduleImpl) {
            ScheduleImpl schedule = (ScheduleImpl)this.selectedValue;
            schedule.setEnabled(false);
            try {
                schedule.save();
            }
            catch (BackingStoreException e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", e.getMessage(), (Throwable)e), "Error Disabling Schedule");
            }
            this.markStale();
        } else if (this.selectedValue instanceof ScheduleEntryImpl) {
            ScheduleEntryImpl entry = (ScheduleEntryImpl)this.selectedValue;
            entry.setEnabled(false);
            try {
                entry.getSchedule().save();
            }
            catch (BackingStoreException e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", e.getMessage(), (Throwable)e), "Error Disabling Schedule Entry");
            }
            this.markStale();
        }
    }

    void enableButtonPressed() {
        if (this.selectedValue instanceof ScheduleImpl) {
            ScheduleImpl schedule = (ScheduleImpl)this.selectedValue;
            schedule.setEnabled(true);
            try {
                schedule.save();
            }
            catch (BackingStoreException e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", e.getMessage(), (Throwable)e), "Error Enabling Schedule");
            }
            this.markStale();
        } else if (this.selectedValue instanceof ScheduleEntryImpl) {
            ScheduleEntryImpl entry = (ScheduleEntryImpl)this.selectedValue;
            entry.setEnabled(true);
            try {
                entry.getSchedule().save();
            }
            catch (BackingStoreException e) {
                Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.jobs", e.getMessage(), (Throwable)e), "Error Enabling Schedule Entry");
            }
            this.markStale();
        }
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private ISchedule getSelectedSchedule() {
        return (ISchedule)(this.selectedValue instanceof ISchedule ? this.selectedValue : null);
    }

    public ISelectionProvider getSelectionProvider() {
        return this.dataTree;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
    }

    public void refresh() {
        try {
            String[] schedulesStorageKeys = ScheduleStore.getSchedules();
            ArrayList<ScheduleImpl> schedules = new ArrayList<ScheduleImpl>(schedulesStorageKeys.length);
            String[] stringArray = schedulesStorageKeys;
            int n = schedulesStorageKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                ScheduleImpl schedule = ScheduleStore.load((String)key, (String)ScheduleManagerImpl.getExternalId((String)key), (boolean)false);
                if (schedule != null) {
                    schedules.add(schedule);
                }
                ++n2;
            }
            this.dataTree.setInput(schedules);
            this.dataTree.setSelection(this.dataTree.getSelection());
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            this.dataTree.setInput((Object)new ISchedule[0]);
        }
        super.refresh();
    }

    void removeButtonPressed() {
        ScheduleImpl schedule = (ScheduleImpl)this.getSelectedSchedule();
        if (schedule == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Schedule", (String)"Do you really want to delete the schedule?")) {
            return;
        }
        try {
            ScheduleStore.remove((String)schedule.getStorageKey(), (String)schedule.getId());
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.markStale();
    }

    void setSelectedValue(Object element) {
        this.selectedValue = element instanceof ISchedule ? element : null;
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(this.selectedValue != null);
        this.enableButton.setEnabled(this.selectedValue instanceof ISchedule && !((ISchedule)this.selectedValue).isEnabled() || this.selectedValue instanceof IScheduleEntry && !((IScheduleEntry)this.selectedValue).isEnabled());
        this.disableButton.setEnabled(this.selectedValue instanceof ISchedule && ((ISchedule)this.selectedValue).isEnabled() || this.selectedValue instanceof IScheduleEntry && ((IScheduleEntry)this.selectedValue).isEnabled());
    }

    static class ViewContentProvider
    implements ITreeContentProvider {
        private static final long serialVersionUID = 1L;
        private static final Object[] NO_CHILDREN = new Object[0];

        ViewContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            return this.getElements(parent);
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof ISchedule) {
                return ((ISchedule)parent).getEntries().toArray();
            }
            if (parent instanceof Collection) {
                return ((Collection)parent).toArray();
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ISchedule) {
                return !((ISchedule)element).getEntries().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }
    }
}

