/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa.weaving;

import java.lang.instrument.IllegalClassFormatException;
import java.util.Arrays;
import java.util.List;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.gemini.jpa.GeminiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.framework.hooks.weaving.WovenClass;

public class WeavingHookTransformer
implements WeavingHook {
    public static List<String> newImports = Arrays.asList("org.eclipse.persistence.indirection;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.queries;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.sessions;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.descriptors.changetracking;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.internal.identitymaps;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.internal.descriptors;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.internal.jpa;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0", "org.eclipse.persistence.internal.weaving;bundle-symbolic-name=org.eclipse.persistence.core;bundle-version=2.3.0");
    private final ClassTransformer transformer;
    private String bsn;
    private Version bundleVersion;
    private boolean importsAdded;

    public WeavingHookTransformer(ClassTransformer transformer, String bundleName, Version bundleVersion) {
        this.transformer = transformer;
        this.bsn = bundleName;
        this.bundleVersion = bundleVersion;
        this.importsAdded = false;
    }

    public void weave(WovenClass cls) {
        String clsName = cls.getClassName();
        GeminiUtil.debugWeaving("Gemini WeavingHookTransformer.weave() called on class ", clsName);
        Bundle b = cls.getBundleWiring().getBundle();
        ClassLoader loader = cls.getBundleWiring().getClassLoader();
        if (this.bsn.equals(b.getSymbolicName()) && this.bundleVersion.equals((Object)b.getVersion())) {
            try {
                byte[] transformedBytes = this.transformer.transform(loader, clsName, null, cls.getProtectionDomain(), cls.getBytes());
                if (transformedBytes == null) {
                    GeminiUtil.debugWeaving(String.valueOf(clsName) + " considered, but not woven by WeavingHookTransformer");
                    return;
                }
                cls.setBytes(transformedBytes);
                GeminiUtil.debugWeaving(String.valueOf(clsName) + " woven by WeavingHookTransformer");
                if (!this.importsAdded) {
                    this.importsAdded = true;
                    List currentImports = cls.getDynamicImports();
                    for (String newImport : newImports) {
                        if (currentImports.contains(newImport)) continue;
                        currentImports.add(newImport);
                        GeminiUtil.debugWeaving("Added dynamic import ", newImport);
                    }
                }
            }
            catch (IllegalClassFormatException e) {
                GeminiUtil.warning("Invalid classfile format - Could not weave " + clsName, e);
                throw new RuntimeException(e);
            }
        }
    }
}

