/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import mx4j.util.Utils;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private MBeanParameterInfo[] signature;
    private String type;
    private int impact;

    public MBeanOperationInfo(String description, Method method) {
        super(method.getName(), description);
        Class<?>[] params = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.signature[i] = new MBeanParameterInfo("", params[i].getName(), "");
        }
        this.type = method.getReturnType().getName();
        this.impact = 3;
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description);
        this.signature = signature == null ? new MBeanParameterInfo[]{} : signature;
        this.type = type;
        this.impact = impact;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature;
    }

    public int getImpact() {
        return this.impact;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String type = this.getReturnType();
        if (type != null) {
            hash = 29 * hash + type.hashCode();
        }
        hash = 29 * hash + Utils.arrayHashCode((Object[])this.getSignature());
        hash = 29 * hash + this.getImpact();
        return hash;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MBeanOperationInfo)) {
            return false;
        }
        MBeanOperationInfo other = (MBeanOperationInfo)obj;
        String thisType = this.getReturnType();
        String otherType = other.getReturnType();
        if (thisType != null ? !thisType.equals(otherType) : otherType != null) {
            return false;
        }
        if (!Utils.arrayEquals((Object[])this.getSignature(), (Object[])other.getSignature())) {
            return false;
        }
        return this.getImpact() == other.getImpact();
    }
}

