/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.UIElement;

public class ToggleCoolbarHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        if (activeWorkbenchWindow instanceof WorkbenchWindow) {
            WorkbenchWindow window = (WorkbenchWindow)activeWorkbenchWindow;
            window.toggleToolbarVisibility();
            ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
            HashMap<String, WorkbenchWindow> filter = new HashMap<String, WorkbenchWindow>();
            filter.put("org.eclipse.ui.IWorkbenchWindow", window);
            commandService.refreshElements(event.getCommand().getId(), filter);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchLocationService wls = (IWorkbenchLocationService)element.getServiceLocator().getService(IWorkbenchLocationService.class);
        IWorkbenchWindow window = wls.getWorkbenchWindow();
        if (window == null || !(window instanceof WorkbenchWindow)) {
            return;
        }
        element.setText(this.isCoolbarVisible((WorkbenchWindow)window) ? WorkbenchMessages.get().ToggleCoolbarVisibilityAction_hide_text : WorkbenchMessages.get().ToggleCoolbarVisibilityAction_show_text);
    }

    private boolean isCoolbarVisible(WorkbenchWindow window) {
        return window.getCoolBarVisible() || window.getPerspectiveBarVisible();
    }
}

