/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FastLeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.quorum.flexible.QuorumHierarchical;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.HierarchicalQuorumTest;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEZeroWeightTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(HierarchicalQuorumTest.class);
    Properties qp;
    int count;
    HashMap<Long, QuorumPeer.QuorumServer> peers;
    ArrayList<LEThread> threads;
    File[] tmpdir;
    int[] port;
    Object finalObj;
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    @Before
    public void setUp() throws Exception {
        this.count = 9;
        this.peers = new HashMap(this.count);
        this.threads = new ArrayList(this.count);
        this.votes = new Vote[this.count];
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.finalObj = new Object();
        String config = "group.1=0:1:2\ngroup.2=3:4:5\ngroup.3=6:7:8\nweight.0=1\nweight.1=1\nweight.2=1\nweight.3=0\nweight.4=0\nweight.5=0\nweight.6=0\nweight.7=0\nweight.8=0";
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        this.qp = new Properties();
        this.qp.load(is);
    }

    @After
    public void tearDown() throws Exception {
        int i = 0;
        while (i < this.threads.size()) {
            LEThread leThread = this.threads.get(i);
            QuorumBase.shutdown(leThread.peer);
            ++i;
        }
    }

    @Test
    public void testZeroWeightQuorum() throws Exception {
        FastLeaderElection[] le = new FastLeaderElection[this.count];
        LOG.info("TestZeroWeightQuorum: " + this.getTestName() + ", " + this.count);
        int i = 0;
        while (i < this.count) {
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(PortAssignment.unique()), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = PortAssignment.unique();
            ++i;
        }
        i = 0;
        while (i < le.length) {
            QuorumHierarchical hq = new QuorumHierarchical(this.qp);
            QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[i], this.tmpdir[i], this.port[i], 3, (long)i, 1000, 2, 2, (QuorumVerifier)hq);
            peer.startLeaderElection();
            LEThread thread = new LEThread(peer, i);
            thread.start();
            this.threads.add(thread);
            ++i;
        }
        LOG.info("Started threads " + this.getTestName());
        i = 0;
        while (i < this.threads.size()) {
            this.threads.get(i).join(15000L);
            if (this.threads.get(i).isAlive()) {
                Assert.fail((String)"Threads didn't join");
            } else if (this.threads.get((int)i).fail) {
                Assert.fail((String)"Elected zero-weight server");
            }
            ++i;
        }
    }

    class LEThread
    extends Thread {
        int i;
        QuorumPeer peer;
        boolean fail;

        LEThread(QuorumPeer peer, int i) {
            this.i = i;
            this.peer = peer;
            LOG.info("Constructor: " + this.getName());
        }

        @Override
        public void run() {
            try {
                Vote v = null;
                this.fail = false;
                do {
                    this.peer.setPeerState(QuorumPeer.ServerState.LOOKING);
                    LOG.info("Going to call leader election.");
                    v = this.peer.getElectionAlg().lookForLeader();
                    if (v == null) {
                        LOG.info("Thread " + this.i + " got a null vote");
                        return;
                    }
                    this.peer.setCurrentVote(v);
                    LOG.info("Finished election: " + this.i + ", " + v.getId());
                    FLEZeroWeightTest.this.votes[this.i] = v;
                    if (this.peer.getPeerState() != QuorumPeer.ServerState.LEADING || this.peer.getId() <= 2L) continue;
                    this.fail = true;
                } while (this.peer.getPeerState() != QuorumPeer.ServerState.FOLLOWING && this.peer.getPeerState() != QuorumPeer.ServerState.LEADING);
                LOG.debug("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

