/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.LeaderElection;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LETest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(LETest.class);
    volatile Vote[] votes;
    volatile boolean leaderDies;
    volatile long leader = -1L;
    Random rand = new Random();

    @Test
    public void testLE() throws Exception {
        int count = 30;
        HashMap<Long, QuorumPeer.QuorumServer> peers = new HashMap<Long, QuorumPeer.QuorumServer>(count);
        ArrayList<LEThread> threads = new ArrayList<LEThread>(count);
        File[] tmpdir = new File[count];
        int[] port = new int[count];
        this.votes = new Vote[count];
        int i = 0;
        while (i < count) {
            peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", PortAssignment.unique())));
            tmpdir[i] = ClientBase.createTmpDir();
            port[i] = PortAssignment.unique();
            ++i;
        }
        LeaderElection[] le = new LeaderElection[count];
        boolean allowOneBadLeader = this.leaderDies = true;
        int i2 = 0;
        while (i2 < le.length) {
            QuorumPeer peer = new QuorumPeer(peers, tmpdir[i2], tmpdir[i2], port[i2], 0, (long)i2, 1000, 2, 2);
            peer.startLeaderElection();
            le[i2] = new LeaderElection(peer);
            LEThread thread = new LEThread(le[i2], peer, i2);
            thread.start();
            threads.add(thread);
            ++i2;
        }
        i2 = 0;
        while (i2 < threads.size()) {
            ((LEThread)threads.get(i2)).join(15000L);
            if (((LEThread)threads.get(i2)).isAlive()) {
                Assert.fail((String)"Threads didn't join");
            }
            ++i2;
        }
        long id = this.votes[0].getId();
        int i3 = 1;
        while (i3 < this.votes.length) {
            if (this.votes[i3] == null) {
                Assert.fail((String)("Thread " + i3 + " had a null vote"));
            }
            if (this.votes[i3].getId() != id) {
                if (allowOneBadLeader && this.votes[i3].getId() == (long)i3) {
                    allowOneBadLeader = false;
                } else {
                    Assert.fail((String)("Thread " + i3 + " got " + this.votes[i3].getId() + " expected " + id));
                }
            }
            ++i3;
        }
    }

    class LEThread
    extends Thread {
        LeaderElection le;
        int i;
        QuorumPeer peer;

        LEThread(LeaderElection le, QuorumPeer peer, int i) {
            this.le = le;
            this.i = i;
            this.peer = peer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Vote v = null;
                while (true) {
                    LETest lETest;
                    LETest.this.votes[this.i] = v = this.le.lookForLeader();
                    if (v.getId() == (long)this.i) {
                        lETest = LETest.this;
                        synchronized (lETest) {
                            if (LETest.this.leaderDies) {
                                LETest.this.leaderDies = false;
                                this.peer.stopLeaderElection();
                                LOG.info("Leader " + this.i + " dying");
                                LETest.this.leader = -2L;
                            } else {
                                LETest.this.leader = this.i;
                            }
                            LETest.this.notifyAll();
                            break;
                        }
                    }
                    lETest = LETest.this;
                    synchronized (lETest) {
                        if (LETest.this.leader == -1L) {
                            LETest.this.wait();
                        }
                        if (LETest.this.leader == v.getId()) {
                            break;
                        }
                    }
                    Thread.sleep(LETest.this.rand.nextInt(1000));
                    this.peer.setCurrentVote(new Vote(this.peer.getId(), 0L));
                }
                LOG.info("Thread " + this.i + " votes " + v);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

