/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.tests.internal;

import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ContextRegistryTests {
    private ContextRegistryImpl contextRegistry;

    private void assertDefined(IPath path) {
        GyrexContextHandle handle = this.contextRegistry.get(path);
        if (handle == null) {
            Assert.fail((String)String.format("context %s was added but no context returned!", path.toString()));
        }
    }

    private void defineContext(IPath path) {
        if (this.contextRegistry.getDefinition(path) == null) {
            ContextDefinition definition = new ContextDefinition(path);
            definition.setName(path.toPortableString());
            this.contextRegistry.saveDefinition(definition);
        } else {
            Assert.fail((String)String.format("Context %s already exists!", path));
        }
    }

    @Before
    public void setUp() throws Exception {
        this.contextRegistry = ContextActivator.getInstance().getContextRegistryImpl();
        CloudDebug.debug = true;
        CloudDebug.zooKeeperPreferences = true;
    }

    @After
    public void tearDown() throws Exception {
        this.contextRegistry = null;
    }

    @Test
    public void test001_DefinedContexts() {
        this.testRemoval();
        String prefix = String.valueOf(System.currentTimeMillis());
        int i = 0;
        while (i < 10) {
            IPath path = new Path("/test").append(prefix).append(String.valueOf(i));
            this.defineContext(path);
            this.assertDefined(path);
            ++i;
        }
        Path base = new Path("/some/level/more");
        IPath p1 = base.append("t1").append("l1");
        IPath p2 = base.append("t2").append("l1");
        IPath p3 = base.append("t2").append("l1").append("b3");
        IPath p4 = base.append("t1").append("l2");
        IPath p5 = base.append("t2").append("l2");
        IPath p6 = base.append("t2").append("l2").append("b3");
        this.defineContext(p1);
        this.defineContext(p2);
        this.defineContext(p3);
        this.defineContext(p4);
        this.defineContext(p5);
        this.defineContext(p6);
        this.assertDefined(p1);
        this.assertDefined(p2);
        this.assertDefined(p3);
        this.assertDefined(p4);
        this.assertDefined(p5);
        this.assertDefined(p6);
        this.testRemoval();
    }

    private void testRemoval() {
        Collection contexts = this.contextRegistry.getDefinedContexts();
        Assert.assertNotNull((Object)contexts);
        Assert.assertFalse((String)"root contexts must always be defined", (boolean)contexts.isEmpty());
        if (contexts.size() > 1) {
            for (ContextDefinition contextDefinition : contexts) {
                IPath path = contextDefinition.getPath();
                if (path.isRoot()) continue;
                this.contextRegistry.removeDefinition(contextDefinition);
                ContextDefinition definition = this.contextRegistry.getDefinition(path);
                if (definition == null) continue;
                Assert.fail((String)String.format("context '%s' still exists after removal", path.toString()));
            }
            contexts = this.contextRegistry.getDefinedContexts();
            Assert.assertNotNull((Object)contexts);
            Assert.assertTrue((String)"wrong size, only root context should be in there", (contexts.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((String)"only root context should be in there", (boolean)((ContextDefinition)contexts.iterator().next()).getPath().isRoot());
        }
    }
}

