/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.DefaultSemanticValidator;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractFromClause;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AggregateFunction;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSemanticValidator
extends AbstractValidator {
    protected DefaultSemanticValidator.CollectionValuedPathExpressionVisitor collectionValuedPathExpressionVisitor;
    private ComparingEntityTypeLiteralVisitor comparingEntityTypeLiteralVisitor;
    protected final SemanticValidatorHelper helper;
    protected boolean registerIdentificationVariable;
    protected DefaultSemanticValidator.StateFieldPathExpressionVisitor stateFieldPathExpressionVisitor;
    protected List<IdentificationVariable> usedIdentificationVariables;
    protected DefaultSemanticValidator.VirtualIdentificationVariableFinder virtualIdentificationVariableFinder;

    protected AbstractSemanticValidator(SemanticValidatorHelper helper) {
        Assert.isNotNull(helper, "The helper cannot be null");
        this.helper = helper;
    }

    protected ComparingEntityTypeLiteralVisitor buildComparingEntityTypeLiteralVisitor() {
        return new ComparingEntityTypeLiteralVisitor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.usedIdentificationVariables.clear();
    }

    protected IdentificationVariable findVirtualIdentificationVariable(AbstractSchemaName expression) {
        DefaultSemanticValidator.VirtualIdentificationVariableFinder visitor = this.virtualIdentificationVariableFinder();
        try {
            expression.accept(visitor);
            IdentificationVariable identificationVariable = visitor.expression;
            return identificationVariable;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected CollectionValuedPathExpression getCollectionValuedPathExpression(Expression expression) {
        DefaultSemanticValidator.CollectionValuedPathExpressionVisitor visitor = this.getCollectionValuedPathExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionValuedPathExpression collectionValuedPathExpression = visitor.expression;
            return collectionValuedPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected DefaultSemanticValidator.CollectionValuedPathExpressionVisitor getCollectionValuedPathExpressionVisitor() {
        if (this.collectionValuedPathExpressionVisitor == null) {
            this.collectionValuedPathExpressionVisitor = new DefaultSemanticValidator.CollectionValuedPathExpressionVisitor();
        }
        return this.collectionValuedPathExpressionVisitor;
    }

    protected ComparingEntityTypeLiteralVisitor getComparingEntityTypeLiteralVisitor() {
        if (this.comparingEntityTypeLiteralVisitor == null) {
            this.comparingEntityTypeLiteralVisitor = this.buildComparingEntityTypeLiteralVisitor();
        }
        return this.comparingEntityTypeLiteralVisitor;
    }

    @Override
    protected JPQLGrammar getGrammar() {
        return this.helper.getGrammar();
    }

    protected StateFieldPathExpression getStateFieldPathExpression(Expression expression) {
        DefaultSemanticValidator.StateFieldPathExpressionVisitor visitor = this.getStateFieldPathExpressionVisitor();
        try {
            expression.accept(visitor);
            StateFieldPathExpression stateFieldPathExpression = visitor.expression;
            return stateFieldPathExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected DefaultSemanticValidator.StateFieldPathExpressionVisitor getStateFieldPathExpressionVisitor() {
        if (this.stateFieldPathExpressionVisitor == null) {
            this.stateFieldPathExpressionVisitor = new DefaultSemanticValidator.StateFieldPathExpressionVisitor();
        }
        return this.stateFieldPathExpressionVisitor;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.usedIdentificationVariables = new ArrayList<IdentificationVariable>();
        this.registerIdentificationVariable = true;
    }

    protected boolean isComparingEntityTypeLiteral(IdentificationVariable expression) {
        ComparingEntityTypeLiteralVisitor visitor = this.getComparingEntityTypeLiteralVisitor();
        try {
            visitor.expression = expression;
            expression.accept(visitor);
            boolean bl = visitor.result;
            return bl;
        }
        finally {
            visitor.result = false;
            visitor.expression = null;
        }
    }

    protected boolean isIdentificationVariableDeclaredAfter(String variableName, int variableNameIndex, int joinIndex, List<JPQLQueryDeclaration> declarations) {
        int index = variableNameIndex;
        int declarationCount = declarations.size();
        while (index < declarationCount) {
            JPQLQueryDeclaration declaration = declarations.get(index);
            if (index != variableNameIndex) {
                if (declaration.isRange() || declaration.isDerived() || declaration.isCollection()) {
                    String nextVariableName = declaration.getVariableName();
                    if (variableName.equalsIgnoreCase(nextVariableName)) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
            if (declaration.hasJoins()) {
                List<Join> joins = declaration.getJoins();
                int endIndex = index == variableNameIndex ? joinIndex : joins.size();
                int subIndex = joinIndex;
                while (subIndex < endIndex) {
                    Join join = joins.get(subIndex);
                    String joinVariableName = this.literal(join.getIdentificationVariable(), LiteralType.IDENTIFICATION_VARIABLE);
                    if (variableName.equalsIgnoreCase(joinVariableName)) {
                        return true;
                    }
                    ++subIndex;
                }
            }
            ++index;
        }
        return false;
    }

    protected void validateAbsExpression(AbsExpression expression) {
    }

    protected void validateAbstractFromClause(AbstractFromClause expression) {
        List<JPQLQueryDeclaration> declarations = this.helper.getDeclarations();
        int index = 0;
        int count = declarations.size();
        while (index < count) {
            String variableName;
            JPQLQueryDeclaration declaration = declarations.get(index);
            if (declaration.isRange() && declaration.hasJoins()) {
                List<Join> joins = declaration.getJoins();
                int joinIndex = 0;
                int joinCount = joins.size();
                while (joinIndex < joinCount) {
                    Join join = joins.get(joinIndex);
                    String variableName2 = this.literal(join.getJoinAssociationPath(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE);
                    if (ExpressionTools.stringIsNotEmpty(variableName2) && this.isIdentificationVariableDeclaredAfter(variableName2, index, joinIndex, declarations)) {
                        int startPosition = this.position(join.getJoinAssociationPath());
                        int endPosition = startPosition + variableName2.length();
                        this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName2);
                    }
                    ++joinIndex;
                }
            } else if (!declaration.isRange() && ExpressionTools.stringIsNotEmpty(variableName = this.literal(declaration.getBaseExpression(), LiteralType.PATH_EXPRESSION_IDENTIFICATION_VARIABLE)) && this.isIdentificationVariableDeclaredAfter(variableName, index, -1, declarations)) {
                int startPosition = this.position(declaration.getDeclarationExpression()) - variableName.length();
                int endPosition = startPosition + variableName.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "ABSTRACT_FROM_CLAUSE_WRONG_ORDER_OF_IDENTIFICATION_VARIABLE_DECLARATION", variableName);
            }
            ++index;
        }
    }

    protected void validateAbstractSchemaName(AbstractSchemaName expression) {
        String abstractSchemaName = expression.getText();
        Object managedType = this.helper.getEntityNamed(abstractSchemaName);
        if (managedType == null) {
            String variableName;
            IdentificationVariable identificationVariable = this.findVirtualIdentificationVariable(expression);
            String string = variableName = identificationVariable != null ? identificationVariable.getText() : null;
            if (ExpressionTools.stringIsNotEmpty(variableName)) {
                Object mapping = this.helper.resolveMapping(variableName, abstractSchemaName);
                Object type = this.helper.getMappingType(mapping);
                if (!this.helper.isTypeResolvable(type)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", abstractSchemaName);
                } else if (!this.helper.isRelationshipMapping(mapping)) {
                    this.addProblem((Expression)expression, "PATH_EXPRESSION_NOT_RELATIONSHIP_MAPPING", abstractSchemaName);
                }
            } else {
                this.addProblem((Expression)expression, "ABSTRACT_SCHEMA_NAME_INVALID", abstractSchemaName);
            }
        }
    }

    protected void validateAggregateFunction(AggregateFunction expression) {
        StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getExpression());
        if (pathExpression != null) {
            this.validateStateFieldPathExpression(pathExpression, false);
        }
    }

    protected void validateArithmeticExpression(ArithmeticExpression expression, String leftExpressionWrongTypeMessageKey, String rightExpressionWrongTypeMessageKey) {
    }

    protected void validateAvgFunction(AvgFunction expression) {
    }

    protected void validateBetweenRangeExpression(BetweenExpression expression) {
    }

    protected void validateCaseExpression(CaseExpression expression) {
    }

    protected void validateCoalesceExpression(CoalesceExpression expression) {
    }

    protected void validateCollectionMemberEntityExpression(CollectionMemberExpression expression) {
    }

    protected void validateCollectionValuedPathExpression(Expression expression, boolean collectionTypeOnly) {
        CollectionValuedPathExpression collectionValuedPathExpression = this.getCollectionValuedPathExpression(expression);
        if (collectionValuedPathExpression != null && collectionValuedPathExpression.hasIdentificationVariable() && !collectionValuedPathExpression.endsWithDot()) {
            Object mapping = this.helper.resolveMapping(expression);
            Object type = this.helper.getMappingType(mapping);
            if (!this.helper.isTypeResolvable(type) || mapping == null) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
            } else if (collectionTypeOnly && !this.helper.isCollectionMapping(mapping) || !collectionTypeOnly && !this.helper.isRelationshipMapping(mapping)) {
                int startPosition = this.position(expression);
                int endPosition = startPosition + this.length(expression);
                this.addProblem(expression, startPosition, endPosition, "COLLECTION_VALUED_PATH_EXPRESSION_NOT_COLLECTION_TYPE", expression.toParsedText());
            }
        }
    }

    protected void validateComparisonExpression(ComparisonExpression expression) {
    }

    protected void validateConcatExpression(ConcatExpression expression) {
    }

    protected void validateConstructorExpression(ConstructorExpression expression) {
    }

    protected void validateCountFunction(CountFunction expression) {
    }

    protected void validateDateTime(DateTime expression) {
    }

    protected void validateDeleteClause(DeleteClause expression) {
    }

    protected void validateDeleteStatement(DeleteStatement expression) {
    }

    protected void validateEntityTypeLiteral(EntityTypeLiteral expression) {
        Object entity;
        String entityTypeName = expression.getEntityTypeName();
        if (ExpressionTools.stringIsNotEmpty(entityTypeName) && (entity = this.helper.getEntityNamed(entityTypeName)) == null) {
            int startIndex = this.position(expression);
            int endIndex = startIndex + entityTypeName.length();
            this.addProblem((Expression)expression, startIndex, endIndex, "ENTITY_TYPE_LITERAL_NOT_RESOLVABLE", entityTypeName);
        }
    }

    protected void validateExistsExpression(ExistsExpression expression) {
    }

    protected void validateFromClause(FromClause expression) {
        this.validateAbstractFromClause(expression);
    }

    protected void validateGroupByClause(GroupByClause expression) {
    }

    protected void validateIdentificationVariable(IdentificationVariable expression) {
        if (!expression.isVirtual()) {
            String variable = expression.getText();
            boolean continueValidating = true;
            if (this.isComparingEntityTypeLiteral(expression)) {
                Object entity = this.helper.getEntityNamed(variable);
                boolean bl = continueValidating = entity == null;
            }
            if (continueValidating) {
                if (this.registerIdentificationVariable) {
                    this.usedIdentificationVariables.add(expression);
                }
                if (ExpressionTools.stringIsNotEmpty(variable)) {
                    this.validateIdentificationVariable(expression, variable);
                }
            }
        } else {
            StateFieldPathExpression pathExpression = expression.getStateFieldPathExpression();
            if (pathExpression != null) {
                pathExpression.accept(this);
            }
        }
    }

    protected void validateIdentificationVariable(IdentificationVariable expression, String variable) {
    }

    protected void validateIdentificationVariableDeclaration(IdentificationVariableDeclaration expression) {
    }

    protected void validateIdentificationVariables() {
        HashMap<String, List<IdentificationVariable>> identificationVariables = new HashMap<String, List<IdentificationVariable>>();
        this.helper.collectLocalDeclarationIdentificationVariables(identificationVariables);
        for (Map.Entry entry : identificationVariables.entrySet()) {
            List variables = (List)entry.getValue();
            if (variables.size() <= 1) continue;
            for (IdentificationVariable variable : variables) {
                this.addProblem((Expression)variable, "IDENTIFICATION_VARIABLE_INVALID_DUPLICATE", variable.getText());
            }
        }
        identificationVariables.clear();
        this.helper.collectAllDeclarationIdentificationVariables(identificationVariables);
        for (IdentificationVariable identificationVariable : this.usedIdentificationVariables) {
            String variableName = identificationVariable.getText();
            if (!ExpressionTools.stringIsNotEmpty(variableName) || identificationVariables.containsKey(variableName.toUpperCase())) continue;
            this.addProblem((Expression)identificationVariable, "IDENTIFICATION_VARIABLE_INVALID_NOT_DECLARED", variableName);
        }
    }

    protected void validateIndexExpression(IndexExpression expression) {
        String variableName = this.literal(expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE);
        if (ExpressionTools.stringIsNotEmpty(variableName) && !this.helper.isCollectionIdentificationVariable(variableName)) {
            this.addProblem(expression.getExpression(), "INDEX_EXPRESSION_WRONG_VARIABLE", variableName);
        }
    }

    protected void validateLengthExpression(LengthExpression expression) {
    }

    protected void validateLikeExpression(LikeExpression expression) {
    }

    protected void validateLocateExpression(LocateExpression expression) {
    }

    protected void validateLowerExpression(LowerExpression expression) {
    }

    protected void validateMapIdentificationVariable(EncapsulatedIdentificationVariableExpression expression) {
    }

    protected void validateModExpression(ModExpression expression) {
    }

    protected void validateNotExpression(NotExpression expression) {
    }

    protected void validateNullComparisonExpression(NullComparisonExpression expression) {
    }

    protected void validateObjectExpression(ObjectExpression expression) {
    }

    protected void validateOnClause(OnClause expression) {
    }

    protected void validateOrderByClause(OrderByClause expression) {
    }

    protected void validateResultVariable(ResultVariable expression) {
    }

    protected void validateSelectClause(SelectClause expression) {
    }

    protected void validateSelectStatement(SelectStatement expression) {
        Expression selectExpression;
        if (!expression.hasGroupByClause() && expression.hasHavingClause() && !this.isValidWithChildCollectionBypass(selectExpression = expression.getSelectClause().getSelectExpression(), "aggregate_expression")) {
            this.addProblem(selectExpression, "SELECT_STATEMENT_SELECT_CLAUSE_HAS_NON_AGGREGATE_FUNCTIONS");
        }
    }

    protected void validateSimpleFromClause(SimpleFromClause expression) {
        this.validateAbstractFromClause(expression);
    }

    protected void validateSimpleSelectClause(SimpleSelectClause expression) {
    }

    protected void validateSqrtExpression(SqrtExpression expression) {
    }

    protected void validateStateFieldPathExpression(StateFieldPathExpression expression, boolean associationFieldValid) {
        if (expression.hasIdentificationVariable() && !expression.endsWithDot()) {
            Object mapping = this.helper.resolveMapping(expression);
            if (mapping != null) {
                if (this.helper.isCollectionMapping(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_COLLECTION_TYPE", expression.toParsedText());
                } else if (!associationFieldValid && this.helper.isRelationshipMapping(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_ASSOCIATION_FIELD", expression.toParsedText());
                } else if (this.helper.isTransient(mapping)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NO_MAPPING", expression.toParsedText());
                }
            } else {
                Object type = this.helper.getType(expression);
                if (!this.helper.isTypeResolvable(type)) {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", expression.toParsedText());
                } else if (this.helper.isEnumType(type)) {
                    String enumConstant = expression.getPath(expression.pathSize() - 1);
                    boolean found = false;
                    String[] stringArray = this.helper.getEnumConstants(type);
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String constant = stringArray[n2];
                        if (constant.equals(enumConstant)) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        int startIndex = this.position(expression) + this.helper.getTypeName(type).length() + 1;
                        int endIndex = startIndex + enumConstant.length();
                        this.addProblem((Expression)expression, startIndex, endIndex, "STATE_FIELD_PATH_EXPRESSION_INVALID_ENUM_CONSTANT", enumConstant);
                    }
                    this.usedIdentificationVariables.remove(expression.getIdentificationVariable());
                } else {
                    this.addProblem((Expression)expression, "STATE_FIELD_PATH_EXPRESSION_NO_MAPPING", expression.toParsedText());
                }
            }
        }
    }

    protected void validateSubstringExpression(SubstringExpression expression) {
    }

    protected void validateSubtractionExpression(SubtractionExpression expression) {
    }

    protected void validateSumFunction(SumFunction expression) {
    }

    protected boolean validateUpdateItem(UpdateItem expression) {
        StateFieldPathExpression pathExpression;
        if (expression.hasStateFieldPathExpression() && (pathExpression = this.getStateFieldPathExpression(expression.getStateFieldPathExpression())) != null && (pathExpression.hasIdentificationVariable() || pathExpression.hasVirtualIdentificationVariable())) {
            Object managedType = this.helper.getManagedType(pathExpression.getIdentificationVariable());
            if (managedType != null) {
                int index = pathExpression.hasVirtualIdentificationVariable() ? 0 : 1;
                int count = pathExpression.pathSize();
                while (index < count) {
                    String path = pathExpression.getPath(index);
                    Object mapping = this.helper.getMappingNamed(managedType, path);
                    if (this.helper.isCollectionMapping(mapping)) {
                        this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                        return false;
                    }
                    if (index + 1 < count) {
                        if (this.helper.isRelationshipMapping(mapping)) {
                            this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                            return false;
                        }
                        if (this.helper.isPropertyMapping(mapping)) {
                            this.addProblem(pathExpression, "UPDATE_ITEM_RELATIONSHIP_PATH_EXPRESSION");
                            return false;
                        }
                    }
                    ++index;
                }
                return true;
            }
            this.addProblem((Expression)pathExpression, "STATE_FIELD_PATH_EXPRESSION_NOT_RESOLVABLE", pathExpression.toParsedText());
        }
        return false;
    }

    protected void validateUpperExpression(UpperExpression expression) {
    }

    protected DefaultSemanticValidator.VirtualIdentificationVariableFinder virtualIdentificationVariableFinder() {
        if (this.virtualIdentificationVariableFinder == null) {
            this.virtualIdentificationVariableFinder = new DefaultSemanticValidator.VirtualIdentificationVariableFinder();
        }
        return this.virtualIdentificationVariableFinder;
    }

    @Override
    public void visit(AbsExpression expression) {
        this.validateAbsExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        this.validateAbstractSchemaName(expression);
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.validateArithmeticExpression(expression, "ADDITION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "ADDITION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AndExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        super.visit(expression);
    }

    @Override
    public void visit(AvgFunction expression) {
        this.validateAvgFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(BadExpression expression) {
    }

    @Override
    public void visit(BetweenExpression expression) {
        if (expression.hasExpression() && expression.hasLowerBoundExpression() && expression.hasUpperBoundExpression()) {
            this.validateBetweenRangeExpression(expression);
        }
        super.visit(expression);
    }

    @Override
    public void visit(CaseExpression expression) {
        this.validateCaseExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(CoalesceExpression expression) {
        this.validateCoalesceExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(CollectionExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        if (expression.hasEntityExpression()) {
            this.validateCollectionMemberEntityExpression(expression);
        }
        this.validateCollectionValuedPathExpression(expression.getCollectionValuedPathExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        if (expression.hasLeftExpression() && expression.hasRightExpression()) {
            this.validateComparisonExpression(expression);
        }
        super.visit(expression);
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.validateConcatExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ConstructorExpression expression) {
        this.validateConstructorExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(CountFunction expression) {
        this.validateCountFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(DateTime expression) {
        this.validateDateTime(expression);
    }

    @Override
    public void visit(DeleteClause expression) {
        this.validateDeleteClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(DeleteStatement expression) {
        this.validateDeleteStatement(expression);
        super.visit(expression);
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.validateArithmeticExpression(expression, "DIVISION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "DIVISION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        this.validateCollectionValuedPathExpression(expression.getExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        this.validateEntityTypeLiteral(expression);
    }

    @Override
    public void visit(EntryExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.validateExistsExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(FromClause expression) {
        this.validateFromClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(GroupByClause expression) {
        this.validateGroupByClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(HavingClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(IdentificationVariable expression) {
        this.validateIdentificationVariable(expression);
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        this.validateIdentificationVariableDeclaration(expression);
        super.visit(expression);
    }

    @Override
    public void visit(IndexExpression expression) {
        this.validateIndexExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(InExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(InputParameter expression) {
    }

    @Override
    public void visit(Join expression) {
        if (expression.hasJoinAssociationPath()) {
            Expression joinAssociationPath = expression.getJoinAssociationPath();
            this.validateCollectionValuedPathExpression(joinAssociationPath, false);
            joinAssociationPath.accept(this);
        }
        if (expression.hasIdentificationVariable()) {
            try {
                this.registerIdentificationVariable = false;
                expression.getIdentificationVariable().accept(this);
            }
            finally {
                this.registerIdentificationVariable = true;
            }
        }
    }

    @Override
    public void visit(JPQLExpression expression) {
        if (expression.hasQueryStatement()) {
            expression.getQueryStatement().accept(this);
            this.validateIdentificationVariables();
        }
    }

    @Override
    public void visit(KeyExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(KeywordExpression expression) {
    }

    @Override
    public void visit(LengthExpression expression) {
        this.validateLengthExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(LikeExpression expression) {
        this.validateLikeExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(LocateExpression expression) {
        this.validateLocateExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(LowerExpression expression) {
        this.validateLowerExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(MaxFunction expression) {
        this.validateAggregateFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(MinFunction expression) {
        this.validateAggregateFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ModExpression expression) {
        this.validateModExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.validateArithmeticExpression(expression, "MULTIPLICATION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "MULTIPLICATION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
        super.visit(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        this.validateNotExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        this.validateNullComparisonExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(NullIfExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(NumericLiteral expression) {
    }

    @Override
    public void visit(ObjectExpression expression) {
        this.validateObjectExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(OnClause expression) {
        this.validateOnClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(OrderByClause expression) {
        this.validateOrderByClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(OrderByItem expression) {
        super.visit(expression);
    }

    @Override
    public void visit(OrExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        expression.getAbstractSchemaName().accept(this);
        try {
            this.registerIdentificationVariable = false;
            expression.getIdentificationVariable().accept(this);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(ResultVariable expression) {
        try {
            this.registerIdentificationVariable = false;
            this.validateResultVariable(expression);
            super.visit(expression);
        }
        finally {
            this.registerIdentificationVariable = true;
        }
    }

    @Override
    public void visit(SelectClause expression) {
        this.validateSelectClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SelectStatement expression) {
        this.validateSelectStatement(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.validateSimpleFromClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        this.validateSimpleSelectClause(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        ArrayList<IdentificationVariable> oldUsedIdentificationVariables = new ArrayList<IdentificationVariable>(this.usedIdentificationVariables);
        this.helper.newSubqueryContext(expression);
        try {
            super.visit(expression);
            this.validateIdentificationVariables();
        }
        finally {
            this.helper.disposeSubqueryContext();
            this.usedIdentificationVariables.retainAll(oldUsedIdentificationVariables);
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.validateCollectionValuedPathExpression(expression.getExpression(), true);
        super.visit(expression);
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.validateSqrtExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        super.visit(expression);
        this.validateStateFieldPathExpression(expression, true);
    }

    @Override
    public void visit(StringLiteral expression) {
    }

    @Override
    public void visit(SubExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.validateSubstringExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.validateSubtractionExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        this.validateSumFunction(expression);
        super.visit(expression);
    }

    @Override
    public void visit(TreatExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(TrimExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(TypeExpression expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UnknownExpression expression) {
    }

    @Override
    public void visit(UpdateClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpdateItem expression) {
        this.validateUpdateItem(expression);
    }

    @Override
    public void visit(UpdateStatement expression) {
        super.visit(expression);
    }

    @Override
    public void visit(UpperExpression expression) {
        this.validateUpperExpression(expression);
        super.visit(expression);
    }

    @Override
    public void visit(ValueExpression expression) {
        this.validateMapIdentificationVariable(expression);
        super.visit(expression);
    }

    @Override
    public void visit(WhenClause expression) {
        super.visit(expression);
    }

    @Override
    public void visit(WhereClause expression) {
        super.visit(expression);
    }

    protected class ComparingEntityTypeLiteralVisitor
    extends AbstractExpressionVisitor {
        IdentificationVariable expression;
        public boolean result;

        protected ComparingEntityTypeLiteralVisitor() {
        }

        public void visit(ComparisonExpression expression) {
            this.result = true;
        }

        public void visit(IdentificationVariable expression) {
            if (this.expression == expression) {
                expression.getParent().accept(this);
            }
        }

        public void visit(SubExpression expression) {
            expression.getParent().accept(this);
        }
    }
}

