/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripleEncapsulatedExpression
extends AbstractEncapsulatedExpression {
    private AbstractExpression firstExpression;
    private boolean hasFirstComma;
    private boolean hasSecondComma;
    private boolean hasSpaceAfterFirstComma;
    private boolean hasSpaceAfterSecondComma;
    private AbstractExpression secondExpression;
    private AbstractExpression thirdExpression;

    protected AbstractTripleEncapsulatedExpression(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getFirstExpression().accept(visitor);
        this.getSecondExpression().accept(visitor);
        this.getThirdExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getFirstExpression());
        children.add(this.getSecondExpression());
        children.add(this.getThirdExpression());
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.firstExpression != null) {
            children.add(this.firstExpression);
        }
        if (this.hasFirstComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterFirstComma) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.secondExpression != null) {
            children.add(this.secondExpression);
        }
        if (this.hasSecondComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterSecondComma) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.thirdExpression != null) {
            children.add(this.thirdExpression);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(3);
        children.add((AbstractExpression)this.getFirstExpression());
        children.add((AbstractExpression)this.getSecondExpression());
        children.add((AbstractExpression)this.getThirdExpression());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(3);
        commas.add(this.hasFirstComma);
        commas.add(this.hasSecondComma);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(3);
        spaces.add(this.hasSpaceAfterFirstComma);
        spaces.add(this.hasSpaceAfterSecondComma);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces, true);
    }

    public final Expression getFirstExpression() {
        if (this.firstExpression == null) {
            this.firstExpression = this.buildNullExpression();
        }
        return this.firstExpression;
    }

    public final Expression getSecondExpression() {
        if (this.secondExpression == null) {
            this.secondExpression = this.buildNullExpression();
        }
        return this.secondExpression;
    }

    public final Expression getThirdExpression() {
        if (this.thirdExpression == null) {
            this.thirdExpression = this.buildNullExpression();
        }
        return this.thirdExpression;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasFirstExpression() || this.hasFirstComma || this.hasSecondExpression() || this.hasSecondComma || this.hasThirdExpression();
    }

    public final boolean hasFirstComma() {
        return this.hasFirstComma;
    }

    public final boolean hasFirstExpression() {
        return this.firstExpression != null && !this.firstExpression.isNull();
    }

    public final boolean hasSecondComma() {
        return this.hasSecondComma;
    }

    public final boolean hasSecondExpression() {
        return this.secondExpression != null && !this.secondExpression.isNull();
    }

    public final boolean hasSpaceAfterFirstComma() {
        return this.hasSpaceAfterFirstComma;
    }

    public final boolean hasSpaceAfterSecondComma() {
        return this.hasSpaceAfterSecondComma;
    }

    public final boolean hasThirdExpression() {
        return this.thirdExpression != null && !this.thirdExpression.isNull();
    }

    protected abstract boolean isThirdExpressionOptional();

    public abstract String parameterExpressionBNF(int var1);

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, boolean tolerant) {
        int count = 0;
        this.firstExpression = this.parse(wordParser, this.getQueryBNF(this.parameterExpressionBNF(0)), tolerant);
        if (this.hasFirstExpression()) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasFirstComma = wordParser.startsWith(',');
        if (this.hasFirstComma) {
            count = 0;
            wordParser.moveForward(1);
            this.hasSpaceAfterFirstComma = wordParser.skipLeadingWhitespace() > 0;
        }
        this.secondExpression = this.parse(wordParser, this.getQueryBNF(this.parameterExpressionBNF(1)), tolerant);
        if (!this.hasFirstComma) {
            this.hasSpaceAfterFirstComma = count > 0;
        }
        count = wordParser.skipLeadingWhitespace();
        this.hasSecondComma = wordParser.startsWith(',');
        if (this.hasSecondComma) {
            count = 0;
            wordParser.moveForward(1);
            this.hasSpaceAfterSecondComma = wordParser.skipLeadingWhitespace() > 0;
        }
        this.thirdExpression = this.parse(wordParser, this.getQueryBNF(this.parameterExpressionBNF(2)), tolerant);
        if (!(this.hasSecondComma || this.isThirdExpressionOptional() && !this.hasThirdExpression())) {
            this.hasSpaceAfterSecondComma = count > 0;
        }
    }

    @Override
    protected final void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.firstExpression != null) {
            this.firstExpression.toParsedText(writer, actual);
        }
        if (this.hasFirstComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterFirstComma) {
            writer.append(' ');
        }
        if (this.secondExpression != null) {
            this.secondExpression.toParsedText(writer, actual);
        }
        if (this.hasSecondComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterSecondComma) {
            writer.append(' ');
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.toParsedText(writer, actual);
        }
    }
}

