/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Arrays;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionFactory
implements Comparable<ExpressionFactory> {
    private ExpressionRegistry expressionRegistry;
    private final String id;
    private String[] identifiers;

    protected ExpressionFactory(String id, String ... identifiers) {
        this.id = id;
        this.identifiers = identifiers;
    }

    void addIdentifier(String identifier) {
        this.identifiers = Arrays.copyOf(this.identifiers, this.identifiers.length + 1);
        this.identifiers[this.identifiers.length - 1] = identifier;
    }

    void addIdentifiers(String ... identifiers) {
        int insertionIndex = this.identifiers.length;
        this.identifiers = Arrays.copyOf(this.identifiers, insertionIndex + identifiers.length);
        System.arraycopy(identifiers, 0, this.identifiers, insertionIndex, identifiers.length);
    }

    protected abstract AbstractExpression buildExpression(AbstractExpression var1, WordParser var2, String var3, JPQLQueryBNF var4, AbstractExpression var5, boolean var6);

    @Override
    public final int compareTo(ExpressionFactory expressionFactory) {
        return this.id.compareTo(expressionFactory.getId());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        ExpressionFactory factory = (ExpressionFactory)object;
        return this.id.equals(factory.id);
    }

    public final ExpressionRegistry getExpressionRegistry() {
        return this.expressionRegistry;
    }

    public final String getId() {
        return this.id;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String[] identifiers() {
        return this.identifiers;
    }

    final void setExpressionRegistry(ExpressionRegistry expressionRegistry) {
        this.expressionRegistry = expressionRegistry;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(id=");
        sb.append(this.id);
        sb.append(", identifiers=");
        sb.append(Arrays.toString(this.identifiers));
        sb.append(")");
        return sb.toString();
    }
}

