/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InExpression
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasLeftParenthesis;
    private boolean hasNot;
    private boolean hasRightParenthesis;
    private boolean hasSpaceAfterIn;
    private String inIdentifier;
    private AbstractExpression inItems;
    private String notIdentifier;
    private Boolean singleInputParameter;

    public InExpression(AbstractExpression parent, AbstractExpression expression) {
        super(parent, "IN");
        if (expression != null) {
            this.expression = expression;
            this.expression.setParent(this);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
        this.getInItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
        children.add(this.getInItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        if (this.hasExpression()) {
            children.add(this.expression);
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasNot) {
            children.add(this.buildStringExpression("NOT"));
        }
        children.add(this.buildStringExpression("IN"));
        if (this.hasLeftParenthesis) {
            children.add(this.buildStringExpression('('));
        } else if (this.hasSpaceAfterIn) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasInItems()) {
            children.add(this.inItems);
        }
        if (this.hasRightParenthesis) {
            children.add(this.buildStringExpression(')'));
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(AbstractExpression expression) {
        if (this.expression == expression) {
            return this.getQueryBNF("in_expression_expression");
        }
        if (this.inItems.isAncestor(expression)) {
            return this.getQueryBNF("in_item");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualInIdentifier() {
        return this.inIdentifier;
    }

    public String getActualNotIdentifier() {
        return this.notIdentifier != null ? this.notIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    public String getExpressionItemBNF() {
        return "in_expression_item";
    }

    public String getIdentifier() {
        return this.hasNot ? "NOT IN" : "IN";
    }

    public Expression getInItems() {
        if (this.inItems == null) {
            this.inItems = this.buildNullExpression();
        }
        return this.inItems;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("in_expression");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasInItems() {
        return this.inItems != null && !this.inItems.isNull();
    }

    public boolean hasLeftParenthesis() {
        return this.hasLeftParenthesis;
    }

    public boolean hasNot() {
        return this.hasNot;
    }

    public boolean hasRightParenthesis() {
        return this.hasRightParenthesis;
    }

    public boolean hasSpaceAfterIn() {
        return this.hasSpaceAfterIn;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("AND") || word.equalsIgnoreCase("OR") || super.isParsingComplete(wordParser, word, expression);
    }

    public boolean isSingleInputParameter() {
        if (this.singleInputParameter == null) {
            if (this.hasLeftParenthesis || this.hasRightParenthesis) {
                this.singleInputParameter = Boolean.FALSE;
            } else {
                WordParser wordParser = new WordParser(this.getInItems().toActualText());
                String word = wordParser.word();
                wordParser.moveForward(word);
                this.singleInputParameter = word.length() > 0 && ExpressionTools.isParameter(word.charAt(0)) && wordParser.isTail();
            }
        }
        return this.singleInputParameter;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.hasNot = wordParser.startsWithIgnoreCase('N');
        if (this.hasNot) {
            this.notIdentifier = wordParser.moveForward("NOT");
            wordParser.skipLeadingWhitespace();
        }
        this.inIdentifier = wordParser.moveForward("IN");
        int count = wordParser.skipLeadingWhitespace();
        this.hasSpaceAfterIn = count > 0;
        this.hasLeftParenthesis = wordParser.startsWith('(');
        if (this.hasLeftParenthesis) {
            wordParser.moveForward(1);
            count = wordParser.skipLeadingWhitespace();
        }
        this.inItems = this.parse(wordParser, this.getQueryBNF("in_item"), tolerant);
        if (this.hasInItems()) {
            count = wordParser.skipLeadingWhitespace();
        }
        this.hasRightParenthesis = wordParser.startsWith(')');
        if (this.hasRightParenthesis) {
            wordParser.moveForward(1);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        if (this.hasExpression()) {
            this.expression.toParsedText(writer, actual);
            writer.append(' ');
        }
        if (this.hasNot) {
            writer.append(actual ? this.notIdentifier : "NOT");
            writer.append(' ');
        }
        writer.append(actual ? this.inIdentifier : "IN");
        if (this.hasLeftParenthesis) {
            writer.append('(');
        } else if (this.hasSpaceAfterIn) {
            writer.append(' ');
        }
        if (this.hasInItems()) {
            this.inItems.toParsedText(writer, actual);
        }
        if (this.hasRightParenthesis) {
            writer.append(')');
        }
    }
}

