/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import org.apache.felix.service.command.CommandProcessor;
import org.eclipse.equinox.console.ssh.SshCommand;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private static SshCommand sshConnection;
    private static boolean isFirstProcessor;
    private ServiceTracker<CommandProcessor, SshCommand> commandProcessorTracker;

    static {
        sshConnection = null;
        isFirstProcessor = true;
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.commandProcessorTracker = new ServiceTracker(context, CommandProcessor.class, (ServiceTrackerCustomizer)new ProcessorCustomizer(context));
        this.commandProcessorTracker.open();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        this.commandProcessorTracker.close();
        try {
            sshConnection.ssh(new String[]{"stop"});
        }
        catch (Exception exception) {}
    }

    public static class ProcessorCustomizer
    implements ServiceTrackerCustomizer<CommandProcessor, SshCommand> {
        private final BundleContext context;

        public ProcessorCustomizer(BundleContext context) {
            this.context = context;
        }

        public SshCommand addingService(ServiceReference<CommandProcessor> reference) {
            CommandProcessor processor = (CommandProcessor)this.context.getService(reference);
            if (processor == null) {
                return null;
            }
            if (isFirstProcessor) {
                isFirstProcessor = false;
                sshConnection = new SshCommand(processor, this.context);
                sshConnection.start();
            } else {
                sshConnection.addCommandProcessor(processor);
            }
            return sshConnection;
        }

        public void modifiedService(ServiceReference<CommandProcessor> reference, SshCommand service) {
        }

        public void removedService(ServiceReference<CommandProcessor> reference, SshCommand service) {
            CommandProcessor processor = (CommandProcessor)this.context.getService(reference);
            service.removeCommandProcessor(processor);
        }
    }
}

