/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.Descriptor;
import org.eclipse.equinox.console.ssh.SshServ;
import org.eclipse.equinox.console.ssh.UserAdminCommand;
import org.eclipse.equinox.console.storage.DigestUtil;
import org.eclipse.equinox.console.storage.SecureUserStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class SshCommand {
    private String defaultHost;
    private int defaultPort;
    private List<CommandProcessor> processors;
    private String host;
    private int port;
    private SshServ sshServ;
    private BundleContext context;
    private ServiceRegistration<?> configuratorRegistration;
    private boolean isEnabled;
    private final Object lock;
    private static final String DEFAULT_USER = "equinox";
    private static final String DEFAULT_PASSWORD = "equinox";
    private static final String DEFAULT_USER_STORE_PROPERTY = "osgi.console.ssh.useDefaultSecureStorage";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String USE_CONFIG_ADMIN_PROP = "osgi.console.useConfigAdmin";
    private static final String SSH_PID = "osgi.console.ssh";
    private static final String ENABLED = "enabled";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SshCommand(CommandProcessor processor, BundleContext context) {
        block6: {
            this.defaultHost = null;
            this.processors = new ArrayList<CommandProcessor>();
            this.host = null;
            this.isEnabled = false;
            this.lock = new Object();
            this.processors.add(processor);
            this.context = context;
            if ("true".equals(context.getProperty(USE_CONFIG_ADMIN_PROP))) {
                Hashtable<String, String> sshProperties = new Hashtable<String, String>();
                ((Dictionary)sshProperties).put("service.pid", SSH_PID);
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.configuratorRegistration = context.registerService(ManagedService.class.getName(), (Object)new SshConfigurator(), sshProperties);
                        break block6;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.out.println("Configuration Admin not available!");
                    return;
                }
            }
            this.parseHostAndPort();
        }
    }

    private void parseHostAndPort() {
        String sshPort = null;
        String consolePropValue = this.context.getProperty(SSH_PID);
        if (consolePropValue != null) {
            int index = consolePropValue.lastIndexOf(":");
            if (index > -1) {
                this.defaultHost = consolePropValue.substring(0, index);
            }
            sshPort = consolePropValue.substring(index + 1);
            this.isEnabled = true;
        }
        if (sshPort != null && !"".equals(sshPort)) {
            try {
                this.defaultPort = Integer.parseInt(sshPort);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public synchronized void start() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "equinox");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"ssh"});
        if ((this.port > 0 || this.defaultPort > 0) && this.isEnabled) {
            try {
                this.ssh(new String[]{"start"});
            }
            catch (Exception e) {
                System.out.println("Cannot start ssh. Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.context.registerService(SshCommand.class.getName(), (Object)this, properties);
    }

    @Descriptor(value="start/stop a ssh server")
    public synchronized void ssh(String[] arguments) throws Exception {
        String command = null;
        String newHost = null;
        int newPort = 0;
        int i = 0;
        while (i < arguments.length) {
            if ("-?".equals(arguments[i]) || "-help".equals(arguments[i])) {
                this.printHelp();
                return;
            }
            if ("start".equals(arguments[i])) {
                command = "start";
            } else if ("stop".equals(arguments[i])) {
                command = "stop";
            } else if ("-port".equals(arguments[i]) && arguments.length > i + 1) {
                newPort = Integer.parseInt(arguments[++i]);
            } else if ("-host".equals(arguments[i]) && arguments.length > i + 1) {
                newHost = arguments[++i];
            } else {
                throw new Exception("Unrecognized ssh command/option " + arguments[i]);
            }
            ++i;
        }
        if (command == null) {
            throw new Exception("No ssh command specified");
        }
        if (newPort != 0) {
            this.port = newPort;
        } else if (this.port == 0) {
            this.port = this.defaultPort;
        }
        if (this.port == 0) {
            throw new Exception("No ssh port specified");
        }
        this.host = newHost != null ? newHost : this.defaultHost;
        if ("start".equals(command)) {
            if (this.sshServ != null) {
                throw new IllegalStateException("ssh is already running on port " + this.port);
            }
            this.checkPortAvailable(this.port);
            this.sshServ = new SshServ(this.processors, this.context, this.host, this.port);
            this.sshServ.setName("equinox ssh");
            if ("true".equals(this.context.getProperty(DEFAULT_USER_STORE_PROPERTY))) {
                try {
                    this.checkUserStore();
                    this.registerUserAdmin();
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    System.out.println("If you want to use secure storage, please install Equinox security bundle and its dependencies");
                    this.sshServ = null;
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.sshServ = null;
                    return;
                }
            }
            try {
                this.sshServ.start();
            }
            catch (RuntimeException runtimeException) {
                this.sshServ = null;
                return;
            }
        }
        if ("stop".equals(command)) {
            if (this.sshServ == null) {
                System.out.println("ssh is not running.");
                return;
            }
            this.sshServ.stopSshServer();
            this.sshServ = null;
        }
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.processors.add(processor);
        if (this.sshServ != null) {
            this.sshServ.addCommandProcessor(processor);
        }
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        this.processors.remove(processor);
        if (this.sshServ != null) {
            this.sshServ.removeCommandProcessor(processor);
        }
    }

    private void checkPortAvailable(int port) throws Exception {
        ServerSocket socket = null;
        try {
            try {
                socket = new ServerSocket(port);
            }
            catch (BindException bindException) {
                throw new Exception("Port " + port + " already in use");
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    private void registerUserAdmin() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "equinox");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"addUser", "addUser", "deleteUser", "resetPassword", "setPassword", "addRoles", "removeRoles", "listUsers"});
        this.context.registerService(UserAdminCommand.class.getName(), (Object)new UserAdminCommand(), properties);
    }

    private void checkUserStore() throws Exception {
        SecureUserStore.initStorage();
        if (SecureUserStore.getUserNames().length == 0) {
            SecureUserStore.putUser("equinox", DigestUtil.encrypt("equinox"), null);
        }
    }

    private void printHelp() {
        StringBuffer help = new StringBuffer();
        help.append("ssh - start simple ssh server");
        help.append("\n");
        help.append("Usage: ssh start | stop [-port port] [-host host]");
        help.append("\n");
        help.append("\t");
        help.append("-port");
        help.append("\t");
        help.append("listen port (default=");
        help.append(this.defaultPort);
        help.append(")");
        help.append("\n");
        help.append("\t");
        help.append("-host");
        help.append("\t");
        help.append("local host address to listen on (default is none - listen on all network interfaces)");
        help.append("\n");
        help.append("\t");
        help.append("-?, -help");
        help.append("\t");
        help.append("show help");
        System.out.println(help.toString());
    }

    class SshConfigurator
    implements ManagedService {
        private Dictionary properties;

        SshConfigurator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updated(Dictionary props) throws ConfigurationException {
            if (props == null) {
                return;
            }
            this.properties = props;
            this.properties.put("service.pid", SshCommand.SSH_PID);
            SshCommand.this.defaultPort = Integer.parseInt((String)this.properties.get(SshCommand.PORT));
            SshCommand.this.defaultHost = (String)this.properties.get(SshCommand.HOST);
            if (this.properties.get(SshCommand.ENABLED) == null) {
                SshCommand.this.isEnabled = false;
            } else {
                SshCommand.this.isEnabled = Boolean.parseBoolean((String)this.properties.get(SshCommand.ENABLED));
            }
            Object object = SshCommand.this.lock;
            synchronized (object) {
                SshCommand.this.configuratorRegistration.setProperties(this.properties);
            }
            if (SshCommand.this.sshServ == null && SshCommand.this.isEnabled) {
                try {
                    SshCommand.this.ssh(new String[]{"start"});
                }
                catch (Exception e) {
                    System.out.println("Cannot start ssh: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

