/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.admin.ui.context.internal.ContextUiActivator;
import org.eclipse.gyrex.admin.ui.context.internal.PreferenceData;
import org.eclipse.gyrex.admin.ui.context.internal.WorkbenchAdapterImpl;
import org.eclipse.gyrex.context.internal.configuration.ContextConfiguration;
import org.eclipse.gyrex.context.internal.preferences.GyrexContextPreferencesImpl;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.internal.registry.ContextRegistryImpl;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.osgi.service.prefs.Preferences;

public class ContextData
implements IPropertySource {
    private static final Object PROP_PATH = new Object();
    private static final Object PROP_NAME = new Object();
    private static final Object PROP_DATA = new Object();
    private Object[] children;
    private Object data;
    private final ContextData parent;
    private final ContextDefinition context;

    public ContextData(ContextDefinition context, ContextData parent) {
        this.context = context;
        this.parent = parent;
    }

    public Object[] getChildren() {
        if (this.children == null) {
            this.load();
        }
        return this.children;
    }

    private ContextRegistryImpl getContextRegistry() {
        return (ContextRegistryImpl)ContextUiActivator.getInstance().getService(IRuntimeContextRegistry.class);
    }

    public Object getData() {
        if (this.data == null) {
            this.load();
        }
        return this.data;
    }

    public Object getEditableValue() {
        return null;
    }

    public String getLabel() {
        return WorkbenchAdapterImpl.getElementText(this.context);
    }

    public ContextData getParent() {
        return this.parent;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new PropertyDescriptor(PROP_PATH, "Path"), new PropertyDescriptor(PROP_NAME, "Name"), new PropertyDescriptor(PROP_DATA, "Settings")};
    }

    public Object getPropertyValue(Object id) {
        if (id == PROP_PATH) {
            return this.context.getPath();
        }
        if (id == PROP_NAME) {
            return this.context.getName();
        }
        if (id == PROP_DATA) {
            return this.getData();
        }
        return null;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    private void load() {
        try {
            Collection contexts = this.getContextRegistry().getDefinedContexts();
            ArrayList<ContextData> children = new ArrayList<ContextData>();
            for (ContextDefinition definition : contexts) {
                if (definition.getPath().segmentCount() <= this.context.getPath().segmentCount() || !this.context.getPath().isPrefixOf(definition.getPath())) continue;
                children.add(new ContextData(definition, this));
            }
            this.children = children.toArray();
        }
        catch (Exception e) {
            this.children = new String[]{ExceptionUtils.getRootCauseMessage((Throwable)e)};
        }
        try {
            this.data = new PreferenceData((Preferences)ContextConfiguration.getRootNodeForContextPreferences(), GyrexContextPreferencesImpl.getPreferencesPathToSettings((IPath)this.context.getPath(), null));
        }
        catch (Exception e) {
            this.data = ExceptionUtils.getRootCauseMessage((Throwable)e);
        }
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

