/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.logback.config.internal;

import ch.qos.logback.classic.Level;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.logback.config.internal.model.Appender;
import org.eclipse.gyrex.logback.config.internal.model.ConsoleAppender;
import org.eclipse.gyrex.logback.config.internal.model.FileAppender;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.internal.model.Logger;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PreferenceBasedLogbackConfigStore {
    private static final String ROTATION_POLICY = "rotationPolicy";
    private static final String SIFTING_MDC_PROPERTYDEFAULT_VALUE = "siftingMdcPropertydefaultValue";
    private static final String SIFTING_MDC_PROPERTY_NAME = "siftingMdcPropertyName";
    private static final String CONSOLE = "console";
    private static final String FILE = "file";
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String INHERIT_OTHER_APPENDERS = "inheritOtherAppenders";
    private static final String APPENDER_REFS = "appenderRefs";
    private static final String COMPRESS_ROTATED_LOGS = "compressRotatedLogs";
    private static final String MAX_FILE_SIZE = "maxFileSize";
    private static final String MAX_HISTORY = "maxHistory";
    private static final String FILE_NAME = "fileName";
    private static final String PATTERN = "pattern";
    private static final String LOGGERS = "loggers";
    private static final String APPENDERS = "appenders";
    private static final String DEFAULT_APPENDER_REFS = "defaultAppenderRefs";
    private static final String DEFAULT_LEVEL = "defaultLevel";

    private Appender loadAppender(String name, Preferences node) throws BackingStoreException {
        String type = node.get(TYPE, null);
        if (StringUtils.equals((String)type, (String)FILE)) {
            return this.loadFileAppender(name, node);
        }
        if (StringUtils.equals((String)type, (String)CONSOLE)) {
            return this.loadConsoleAppender(name, node);
        }
        throw new IllegalArgumentException(String.format("unknown appender type '%s' (appender '%s')", type, name));
    }

    public LogbackConfig loadConfig(Preferences node) throws BackingStoreException {
        String[] loggers;
        String[] appenders;
        LogbackConfig config = new LogbackConfig();
        String defaultLevel = node.get(DEFAULT_LEVEL, null);
        if (defaultLevel != null) {
            config.setDefaultLevel(Level.toLevel((String)defaultLevel, (Level)Level.INFO));
        }
        String[] stringArray = node.node(DEFAULT_APPENDER_REFS).keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String appender = stringArray[n2];
            config.getDefaultAppenders().add(appender);
            ++n2;
        }
        String[] stringArray2 = appenders = node.node(APPENDERS).childrenNames();
        int n3 = appenders.length;
        n = 0;
        while (n < n3) {
            String appender = stringArray2[n];
            config.addAppender(this.loadAppender(appender, node.node(APPENDERS).node(appender)));
            ++n;
        }
        String[] stringArray3 = loggers = node.node(LOGGERS).childrenNames();
        int n4 = loggers.length;
        n3 = 0;
        while (n3 < n4) {
            String logger = stringArray3[n3];
            config.addLogger(this.loadLogger(logger, node.node(LOGGERS).node(logger)));
            ++n3;
        }
        return config;
    }

    private Appender loadConsoleAppender(String name, Preferences node) throws BackingStoreException {
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName(name);
        appender.setPattern(node.get(PATTERN, null));
        return appender;
    }

    private Appender loadFileAppender(String name, Preferences node) throws BackingStoreException {
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName(name);
        fileAppender.setPattern(node.get(PATTERN, null));
        fileAppender.setFileName(node.get(FILE_NAME, null));
        try {
            fileAppender.setRotationPolicy(FileAppender.RotationPolicy.valueOf(node.get(ROTATION_POLICY, null)));
            fileAppender.setMaxHistory(node.get(MAX_HISTORY, null));
            fileAppender.setMaxFileSize(node.get(MAX_FILE_SIZE, null));
            if (node.get(COMPRESS_ROTATED_LOGS, null) != null) {
                fileAppender.setCompressRotatedLogs(node.getBoolean(COMPRESS_ROTATED_LOGS, true));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            fileAppender.setRotationPolicy(null);
        }
        if (node.get(SIFTING_MDC_PROPERTY_NAME, null) != null) {
            fileAppender.setSiftingMdcPropertyName(node.get(SIFTING_MDC_PROPERTY_NAME, null));
            if (node.get(SIFTING_MDC_PROPERTYDEFAULT_VALUE, null) != null) {
                fileAppender.setSiftingMdcPropertyDefaultValue(node.get(SIFTING_MDC_PROPERTYDEFAULT_VALUE, null));
            }
        }
        return fileAppender;
    }

    private Logger loadLogger(String name, Preferences node) throws BackingStoreException {
        Logger logger = new Logger();
        logger.setName(name);
        if (node.get(LEVEL, null) != null) {
            logger.setLevel(Level.toLevel((String)node.get(LEVEL, null), (Level)Level.INFO));
        }
        if (node.get(INHERIT_OTHER_APPENDERS, null) != null) {
            logger.setInheritOtherAppenders(node.getBoolean(INHERIT_OTHER_APPENDERS, true));
        }
        String[] stringArray = node.node(APPENDER_REFS).keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String appender = stringArray[n2];
            logger.getAppenderReferences().add(appender);
            ++n2;
        }
        return logger;
    }

    private void saveAppender(Appender appender, Preferences node) throws BackingStoreException {
        if (appender instanceof ConsoleAppender) {
            node.put(TYPE, CONSOLE);
            this.saveConsoleAppender((ConsoleAppender)appender, node);
        } else if (appender instanceof FileAppender) {
            node.put(TYPE, FILE);
            this.saveFileAppender((FileAppender)appender, node);
        } else {
            throw new IllegalArgumentException(String.format("unknown appender type '%s' (appender '%s')", appender.getClass().getSimpleName(), appender.getName()));
        }
    }

    private void saveAppenderRefs(List<String> appenderRefs, Preferences appenderRefsNode) throws BackingStoreException {
        if (appenderRefs.isEmpty()) {
            appenderRefsNode.removeNode();
        } else {
            String[] stringArray = appenderRefsNode.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String appender = stringArray[n2];
                if (!appenderRefs.contains(appender)) {
                    appenderRefsNode.remove(appender);
                }
                ++n2;
            }
            for (String appender : appenderRefs) {
                appenderRefsNode.put(appender, "inUse");
            }
        }
    }

    public void saveConfig(LogbackConfig config, Preferences node) throws BackingStoreException {
        if (config.getDefaultLevel() != Level.INFO) {
            node.put(DEFAULT_LEVEL, config.getDefaultLevel().toString());
        } else {
            node.remove(DEFAULT_LEVEL);
        }
        this.saveAppenderRefs(config.getDefaultAppenders(), node.node(DEFAULT_APPENDER_REFS));
        Preferences appendersNode = node.node(APPENDERS);
        Map<String, Appender> appenders = config.getAppenders();
        String[] stringArray = appendersNode.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (!appenders.containsKey(string)) {
                appendersNode.node(string).removeNode();
            }
            ++n2;
        }
        for (Appender appender : appenders.values()) {
            this.saveAppender(appender, appendersNode.node(appender.getName()));
        }
        Preferences preferences = node.node(LOGGERS);
        Map<String, Logger> loggers = config.getLoggers();
        String[] stringArray2 = preferences.childrenNames();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String logger = stringArray2[n4];
            if (!loggers.containsKey(logger)) {
                preferences.node(logger).removeNode();
            }
            ++n4;
        }
        for (Logger logger : loggers.values()) {
            this.saveLogger(logger, preferences.node(logger.getName()));
        }
        node.flush();
    }

    private void saveConsoleAppender(ConsoleAppender appender, Preferences node) {
        if (appender.getPattern() != null) {
            node.put(PATTERN, appender.getPattern());
        } else {
            node.remove(PATTERN);
        }
    }

    private void saveFileAppender(FileAppender appender, Preferences node) {
        if (appender.getPattern() != null) {
            node.put(PATTERN, appender.getPattern());
        } else {
            node.remove(PATTERN);
        }
        if (appender.getFileName() != null) {
            node.put(FILE_NAME, appender.getFileName());
        } else {
            node.remove(FILE_NAME);
        }
        if (appender.getRotationPolicy() != null) {
            node.put(ROTATION_POLICY, appender.getRotationPolicy().name());
        } else {
            node.remove(ROTATION_POLICY);
        }
        if (appender.getMaxHistory() != null) {
            node.put(MAX_HISTORY, appender.getMaxHistory());
        } else {
            node.remove(MAX_HISTORY);
        }
        if (appender.getMaxFileSize() != null) {
            node.put(MAX_FILE_SIZE, appender.getMaxFileSize());
        } else {
            node.remove(MAX_FILE_SIZE);
        }
        if (appender.isSeparateLogOutputsPerMdcProperty()) {
            node.put(SIFTING_MDC_PROPERTY_NAME, appender.getSiftingMdcPropertyName());
            node.put(SIFTING_MDC_PROPERTYDEFAULT_VALUE, StringUtils.trimToEmpty((String)appender.getSiftingMdcPropertyDefaultValue()));
        } else {
            node.remove(SIFTING_MDC_PROPERTY_NAME);
            node.remove(SIFTING_MDC_PROPERTYDEFAULT_VALUE);
        }
        if (!appender.isCompressRotatedLogs()) {
            node.putBoolean(COMPRESS_ROTATED_LOGS, false);
        } else {
            node.remove(COMPRESS_ROTATED_LOGS);
        }
    }

    private void saveLogger(Logger logger, Preferences node) throws BackingStoreException {
        if (logger.getLevel() != null) {
            node.put(LEVEL, logger.getLevel().toString());
        } else {
            node.remove(LEVEL);
        }
        if (!logger.isInheritOtherAppenders()) {
            node.putBoolean(INHERIT_OTHER_APPENDERS, false);
        } else {
            node.remove(INHERIT_OTHER_APPENDERS);
        }
        this.saveAppenderRefs(logger.getAppenderReferences(), node.node(APPENDER_REFS));
    }
}

