/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.osgi.internal;

import org.eclipse.rwt.application.ApplicationConfigurator;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Matcher {
    private final ServiceReference<HttpService> httpServiceReference;
    private final ServiceReference<ApplicationConfigurator> configuratorReference;

    Matcher(ServiceReference<HttpService> httpServiceReference, ServiceReference<ApplicationConfigurator> configuratorReference) {
        this.httpServiceReference = httpServiceReference;
        this.configuratorReference = configuratorReference;
    }

    public boolean matches() {
        return this.matchesHttpService() && this.matchesConfigurator();
    }

    private boolean matchesHttpService() {
        return this.matchesTarget(this.configuratorReference, this.httpServiceReference, HttpService.class);
    }

    private boolean matchesConfigurator() {
        Class<ApplicationConfigurator> targetType = ApplicationConfigurator.class;
        return this.matchesTarget(this.httpServiceReference, this.configuratorReference, targetType);
    }

    private boolean matchesTarget(ServiceReference<?> serviceReference, ServiceReference<?> targetReference, Class<?> targetType) {
        boolean result = targetReference != null;
        String filterExpression = this.getFilterExpression(serviceReference, targetType);
        if (filterExpression != null) {
            Filter filter = this.createFilter(filterExpression);
            result = filter.match(targetReference);
        }
        return result;
    }

    private String getFilterExpression(ServiceReference<?> serviceReference, Class targetType) {
        String result = null;
        if (serviceReference != null) {
            String targetKey = Matcher.createTargetKey(targetType);
            result = (String)serviceReference.getProperty(targetKey);
        }
        return result;
    }

    private Filter createFilter(String filterExpression) {
        Filter result = null;
        try {
            result = FrameworkUtil.createFilter((String)filterExpression);
        }
        catch (InvalidSyntaxException ise) {
            throw new IllegalArgumentException(ise);
        }
        return result;
    }

    static String createTargetKey(Class targetType) {
        StringBuilder result = new StringBuilder();
        result.append(targetType.getSimpleName().substring(0, 1).toLowerCase());
        result.append(targetType.getSimpleName().substring(1));
        result.append(".target");
        return result.toString();
    }
}

