/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.CertificatsSection;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.ChannelsSection;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.JettyConfigActivator;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutFactory;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JettyConfigurationPage
extends ConfigurationPage {
    private static final String INPUT = "input";
    private DataBindingContext bindingContext;
    boolean disposed;

    protected void createFormContent(IManagedForm managedForm) {
        this.setTitle("Jetty Configuration");
        Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
        this.bindingContext = new DataBindingContext(realm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)true, (int)2));
        body.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        FormToolkit toolkit = managedForm.getToolkit();
        Composite left = toolkit.createComposite(body);
        left.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        left.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        ChannelsSection channelsSection = new ChannelsSection(left, this);
        channelsSection.getSection().setLayoutData((Object)new GridData(1808));
        managedForm.addPart((IFormPart)channelsSection);
        Composite right = toolkit.createComposite(body);
        right.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        right.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        CertificatsSection certificatesSection = new CertificatsSection(right, this);
        certificatesSection.getSection().setLayoutData((Object)new GridData(1808));
        managedForm.addPart((IFormPart)certificatesSection);
        this.initializeInput();
    }

    public void dispose() {
        this.disposed = true;
        this.bindingContext.dispose();
        this.bindingContext = null;
        super.dispose();
    }

    public DataBindingContext getBindingContext() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.bindingContext;
    }

    private void initializeInput() {
        IManagedForm managedForm = this.getManagedForm();
        try {
            IJettyManager manager = JettyConfigActivator.getInstance().getJettyManager();
            managedForm.setInput((Object)manager);
            managedForm.getMessageManager().removeMessage((Object)INPUT);
        }
        catch (IllegalStateException e) {
            managedForm.getMessageManager().addMessage((Object)INPUT, "The Jetty component could not be initialized. " + e.getMessage(), (Object)e, 3);
            Job job = new Job("Load input"){

                protected IStatus run(IProgressMonitor monitor) {
                    JettyConfigurationPage.this.initializeInput();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(800L);
        }
    }
}

