/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.servlet;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.eclipse.rap.rwt.osgi.ApplicationLauncher;
import org.eclipse.rap.rwt.osgi.ApplicationReference;
import org.eclipse.rap.ui.internal.servlet.WorkbenchApplicationConfigurator;
import org.eclipse.rwt.application.ApplicationConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpServiceTracker
extends ServiceTracker<HttpService, HttpService> {
    public static final String ID_HTTP_CONTEXT = "org.eclipse.rap.httpcontext";
    private HttpContextExtensionService httpCtxExtService;
    private HttpContextTracker httpContextTracker;
    private ApplicationLauncherTracker applicationLauncherTracker;
    private ApplicationLauncher applicationLauncher;
    private ApplicationReference applicationReference;

    public HttpServiceTracker(BundleContext context) {
        super(context, HttpService.class.getName(), null);
    }

    public HttpService addingService(ServiceReference<HttpService> reference) {
        HttpService result = (HttpService)this.context.getService(reference);
        HttpContext httpContext = this.httpCtxExtService.getHttpContext(reference, ID_HTTP_CONTEXT);
        this.applicationReference = this.startApplication(reference, result, httpContext);
        return result;
    }

    public void removedService(ServiceReference<HttpService> reference, HttpService service) {
        this.applicationReference.stopApplication();
        super.removedService(reference, (Object)service);
    }

    public void open() {
        this.httpContextTracker = new HttpContextTracker(this.context);
        this.httpContextTracker.open();
    }

    public void close() {
        super.close();
        this.httpContextTracker.close();
    }

    private ApplicationReference startApplication(ServiceReference<HttpService> httpServiceReference, HttpService service, HttpContext context) {
        WorkbenchApplicationConfigurator configurator = new WorkbenchApplicationConfigurator(httpServiceReference);
        String contextDirectory = HttpServiceTracker.findContextPath().toString();
        return this.applicationLauncher.launch((ApplicationConfigurator)configurator, service, context, null, contextDirectory);
    }

    private static IPath findContextPath() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        return stateLocation.append("context");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationLauncherTracker
    extends ServiceTracker<ApplicationLauncher, ApplicationLauncher> {
        private ApplicationLauncherTracker(BundleContext context) {
            super(context, ApplicationLauncher.class.getName(), null);
        }

        public ApplicationLauncher addingService(ServiceReference<ApplicationLauncher> reference) {
            ApplicationLauncher result = (ApplicationLauncher)super.addingService(reference);
            HttpServiceTracker.this.applicationLauncher = (ApplicationLauncher)this.context.getService(reference);
            HttpServiceTracker.super.open();
            return result;
        }

        public void removedService(ServiceReference<ApplicationLauncher> reference, ApplicationLauncher service) {
            HttpServiceTracker.this.applicationLauncher = null;
            super.removedService(reference, (Object)service);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpContextTracker
    extends ServiceTracker<HttpContextExtensionService, HttpContextExtensionService> {
        private HttpContextTracker(BundleContext context) {
            super(context, HttpContextExtensionService.class.getName(), null);
        }

        public HttpContextExtensionService addingService(ServiceReference<HttpContextExtensionService> reference) {
            HttpContextExtensionService result = (HttpContextExtensionService)super.addingService(reference);
            HttpServiceTracker.this.httpCtxExtService = (HttpContextExtensionService)this.context.getService(reference);
            HttpServiceTracker.this.applicationLauncherTracker = new ApplicationLauncherTracker(this.context);
            HttpServiceTracker.this.applicationLauncherTracker.open();
            return result;
        }

        public void removedService(ServiceReference<HttpContextExtensionService> reference, HttpContextExtensionService service) {
            HttpServiceTracker.this.applicationLauncherTracker.close();
            HttpServiceTracker.this.httpCtxExtService = null;
            super.removedService(reference, (Object)service);
        }
    }
}

