/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.NewByteArrayInputStream;

public class AccessibleByteArrayOutputStream
extends ByteArrayOutputStream {
    public AccessibleByteArrayOutputStream() {
    }

    public AccessibleByteArrayOutputStream(int size) {
        super(size);
    }

    public byte[] getInternalByteArray() {
        return this.buf;
    }

    public void readFrom(InputStream in) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, this.buf.length)) != -1) {
            this.write(buffer, 0, read);
        }
    }

    public InputStream getInputStream() {
        return new NewByteArrayInputStream(this.buf, 0, this.count);
    }

    public static InputStream copyStream(InputStream in, int bufferSize) throws IOException {
        AccessibleByteArrayOutputStream raw = new AccessibleByteArrayOutputStream(bufferSize);
        raw.readFrom(in);
        return raw.getInputStream();
    }
}

