/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

public class ReuseFactory {
    private static final Integer[] staticInts = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12), new Integer(13), new Integer(14), new Integer(15), new Integer(16), new Integer(17), new Integer(18)};
    private static final Integer FIFTY_TWO = new Integer(52);
    private static final Integer TWENTY_THREE = new Integer(23);
    private static final Integer MAXINT = new Integer(Integer.MAX_VALUE);
    private static final Integer MINUS_ONE = new Integer(-1);
    private static final Short[] staticShorts = new Short[]{new Short(0), new Short(1), new Short(2), new Short(3), new Short(4), new Short(5), new Short(6), new Short(7), new Short(8), new Short(9), new Short(10)};
    private static final Byte[] staticBytes = new Byte[]{new Byte(0), new Byte(1), new Byte(2), new Byte(3), new Byte(4), new Byte(5), new Byte(6), new Byte(7), new Byte(8), new Byte(9), new Byte(10)};
    private static final Long[] staticLongs = new Long[]{new Long(0L), new Long(1L), new Long(2L), new Long(3L), new Long(4L), new Long(5L), new Long(6L), new Long(7L), new Long(8L), new Long(9L), new Long(10L)};
    private static final byte[] staticZeroLenByteArray = new byte[0];

    private ReuseFactory() {
    }

    public static Integer getInteger(int i) {
        if (i >= 0 && i < staticInts.length) {
            return staticInts[i];
        }
        switch (i) {
            case 23: {
                return TWENTY_THREE;
            }
            case 52: {
                return FIFTY_TWO;
            }
            case 0x7FFFFFFF: {
                return MAXINT;
            }
            case -1: {
                return MINUS_ONE;
            }
        }
        return new Integer(i);
    }

    public static Short getShort(short i) {
        if (i >= 0 && i < staticShorts.length) {
            return staticShorts[i];
        }
        return new Short(i);
    }

    public static Byte getByte(byte i) {
        if (i >= 0 && i < staticBytes.length) {
            return staticBytes[i];
        }
        return new Byte(i);
    }

    public static Long getLong(long i) {
        if (i >= 0L && i < (long)staticLongs.length) {
            return staticLongs[(int)i];
        }
        return new Long(i);
    }

    public static Boolean getBoolean(boolean b) {
        return b ? Boolean.TRUE : Boolean.FALSE;
    }

    public static byte[] getZeroLenByteArray() {
        return staticZeroLenByteArray;
    }
}

