/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.version.util.VerGen;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class VerGenTest
extends ZKTestCase {
    private String input;
    private Object[] expected;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] objectArrayArray = new Object[4][];
        Object[] objectArray = new Object[2];
        objectArray[0] = "1.2.3";
        Object[] objectArray2 = new Object[4];
        objectArray2[0] = 1;
        objectArray2[1] = 2;
        objectArray2[2] = 3;
        objectArray[1] = objectArray2;
        objectArrayArray[0] = objectArray;
        objectArrayArray[1] = new Object[]{"1.2.3-dev", new Object[]{1, 2, 3, "dev"}};
        objectArrayArray[2] = new Object[]{"1.2.3-SNAPSHOT", new Object[]{1, 2, 3, "SNAPSHOT"}};
        objectArrayArray[3] = new Object[]{"1.2.3-foo-bar+123", new Object[]{1, 2, 3, "foo-bar+123"}};
        return Arrays.asList(objectArrayArray);
    }

    public VerGenTest(String input, Object[] expected) {
        this.input = input;
        this.expected = expected;
    }

    @Test
    public void testParser() {
        VerGen.Version v = VerGen.parseVersionString((String)this.input);
        Assert.assertEquals((Object)this.expected[0], (Object)v.maj);
        Assert.assertEquals((Object)this.expected[1], (Object)v.min);
        Assert.assertEquals((Object)this.expected[2], (Object)v.micro);
        Assert.assertEquals((Object)this.expected[3], (Object)v.qualifier);
    }

    @Test
    public void testGenFile() throws Exception {
        VerGen.Version v = VerGen.parseVersionString((String)this.input);
        File outputDir = ClientBase.createTmpDir();
        VerGen.generateFile((File)outputDir, (VerGen.Version)v, (int)1, (String)"Nov1");
        ClientBase.recursiveDelete(outputDir);
    }
}

