/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHammerTest
extends ClientBase {
    protected static final Logger LOG = LoggerFactory.getLogger(ClientHammerTest.class);
    private static final long HAMMERTHREAD_LATENCY = 5L;

    @Test
    public void testHammerBasic() throws Throwable {
        this.runHammer(10, 1000);
    }

    public void runHammer(int threadCount, int childCount) throws Throwable {
        try {
            HammerThread[] threads = new HammerThread[threadCount];
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < threads.length) {
                TestableZooKeeper zk = this.createClient();
                String prefix = "/test-" + i;
                zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                prefix = String.valueOf(prefix) + "/";
                BasicHammerThread thread = new BasicHammerThread("BasicHammerThread-" + i, zk, prefix, childCount);
                thread.start();
                threads[i] = thread;
                ++i;
            }
            this.verifyHammer(start, threads, childCount);
        }
        catch (Throwable t) {
            LOG.error("test Assert.failed", t);
            throw t;
        }
    }

    @Test
    public void testHammerSuper() throws Throwable {
        try {
            int threadCount = 5;
            int childCount = 10;
            HammerThread[] threads = new HammerThread[5];
            long start = System.currentTimeMillis();
            int i = 0;
            while (i < threads.length) {
                String prefix = "/test-" + i;
                try (TestableZooKeeper zk = this.createClient();){
                    zk.create(prefix, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                prefix = String.valueOf(prefix) + "/";
                SuperHammerThread thread = new SuperHammerThread("SuperHammerThread-" + i, this, prefix, 10);
                thread.start();
                threads[i] = thread;
                ++i;
            }
            this.verifyHammer(start, threads, 10);
        }
        catch (Throwable t) {
            LOG.error("test Assert.failed", t);
            throw t;
        }
    }

    public void verifyHammer(long start, HammerThread[] threads, int childCount) throws IOException, InterruptedException, KeeperException {
        int n;
        LOG.info("Starting check for completed hammers");
        int workingCount = threads.length;
        int i = 0;
        while (i < 120) {
            Thread.sleep(10000L);
            HammerThread[] hammerThreadArray = threads;
            int n2 = threads.length;
            n = 0;
            while (n < n2) {
                HammerThread h = hammerThreadArray[n];
                if (!h.isAlive() || h.current == h.count) {
                    --workingCount;
                }
                ++n;
            }
            if (workingCount == 0) break;
            workingCount = threads.length;
            ++i;
        }
        if (workingCount > 0) {
            HammerThread[] hammerThreadArray = threads;
            n = threads.length;
            int h = 0;
            while (h < n) {
                HammerThread h2 = hammerThreadArray[h];
                LOG.warn(String.valueOf(h2.getName()) + " never finished creation, current:" + h2.current);
                ++h;
            }
        } else {
            LOG.info("Hammer threads completed creation operations");
        }
        HammerThread[] hammerThreadArray = threads;
        n = threads.length;
        int h = 0;
        while (h < n) {
            HammerThread h3 = hammerThreadArray[h];
            int safetyFactor = 3;
            ClientHammerTest.verifyThreadTerminated(h3, (long)(threads.length * childCount) * 5L * 3L);
            ++h;
        }
        LOG.info(new Date() + " Total time " + (System.currentTimeMillis() - start));
        try (TestableZooKeeper zk = this.createClient();){
            LOG.info("******************* Connected to ZooKeeper" + new Date());
            int i2 = 0;
            while (i2 < threads.length) {
                LOG.info("Doing thread: " + i2 + " " + new Date());
                List children = zk.getChildren("/test-" + i2, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i2, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
                ++i2;
            }
            i2 = 0;
            while (i2 < threads.length) {
                List children = zk.getChildren("/test-" + i2, false);
                Assert.assertEquals((long)childCount, (long)children.size());
                children = zk.getChildren("/test-" + i2, false, null);
                Assert.assertEquals((long)childCount, (long)children.size());
                ++i2;
            }
        }
    }

    private static class BasicHammerThread
    extends HammerThread {
        private final ZooKeeper zk;
        private final String prefix;

        BasicHammerThread(String name, ZooKeeper zk, String prefix, int count) {
            super(name, count);
            this.zk = zk;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            byte[] b = new byte[256];
            try {
                try {
                    while (this.current < this.count) {
                        Thread.sleep(5L);
                        this.zk.create(String.valueOf(this.prefix) + this.current, b, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        ++this.current;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Client create operation Assert.failed", t);
                    try {
                        this.zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Unexpected", (Throwable)e);
                    }
                }
            }
            finally {
                try {
                    this.zk.close();
                }
                catch (InterruptedException e) {
                    LOG.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    private static abstract class HammerThread
    extends Thread {
        protected final int count;
        protected volatile int current = 0;

        HammerThread(String name, int count) {
            super(name);
            this.count = count;
        }
    }

    private static class SuperHammerThread
    extends HammerThread {
        private final ClientHammerTest parent;
        private final String prefix;

        SuperHammerThread(String name, ClientHammerTest parent, String prefix, int count) {
            super(name, count);
            this.parent = parent;
            this.prefix = prefix;
        }

        @Override
        public void run() {
            byte[] b = new byte[256];
            try {
                while (this.current < this.count) {
                    TestableZooKeeper zk = this.parent.createClient();
                    try {
                        zk.create(String.valueOf(this.prefix) + this.current, b, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                    finally {
                        try {
                            zk.close();
                        }
                        catch (InterruptedException e) {
                            LOG.warn("Unexpected", (Throwable)e);
                        }
                    }
                    ++this.current;
                }
            }
            catch (Throwable t) {
                LOG.error("Client create operation Assert.failed", t);
            }
        }
    }
}

