/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class StatTest
extends ClientBase {
    private ZooKeeper zk;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.zk = this.createClient();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.zk.close();
    }

    private Stat newStat() {
        Stat stat = new Stat();
        stat.setAversion(100);
        stat.setCtime(100L);
        stat.setCversion(100);
        stat.setCzxid(100L);
        stat.setDataLength(100);
        stat.setEphemeralOwner(100L);
        stat.setMtime(100L);
        stat.setMzxid(100L);
        stat.setNumChildren(100);
        stat.setPzxid(100L);
        stat.setVersion(100);
        return stat;
    }

    @Test
    public void testBasic() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
    }

    @Test
    public void testChild() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        String childname = String.valueOf(name) + "/bar";
        this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)(stat.getCzxid() + 1L), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)1L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)1L, (long)stat.getNumChildren());
        stat = this.newStat();
        this.zk.getData(childname, false, stat);
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)this.zk.getSessionId(), (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)childname.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
    }

    @Test
    public void testChildren() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        int i = 0;
        while (i < 10) {
            String childname = String.valueOf(name) + "/bar" + i;
            this.zk.create(childname, childname.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Stat stat = this.newStat();
            this.zk.getData(name, false, stat);
            Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
            Assert.assertEquals((long)(stat.getCzxid() + (long)i + 1L), (long)stat.getPzxid());
            Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
            Assert.assertEquals((long)(i + 1), (long)stat.getCversion());
            Assert.assertEquals((long)0L, (long)stat.getVersion());
            Assert.assertEquals((long)0L, (long)stat.getAversion());
            Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
            Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
            Assert.assertEquals((long)(i + 1), (long)stat.getNumChildren());
            ++i;
        }
    }

    @Test
    public void testDataSizeChange() throws IOException, KeeperException, InterruptedException {
        String name = "/foo";
        this.zk.create(name, name.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        Stat stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertEquals((long)stat.getCtime(), (long)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)0L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)name.length(), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
        this.zk.setData(name, (String.valueOf(name) + name).getBytes(), -1);
        stat = this.newStat();
        this.zk.getData(name, false, stat);
        Assert.assertNotSame((Object)stat.getCzxid(), (Object)stat.getMzxid());
        Assert.assertEquals((long)stat.getCzxid(), (long)stat.getPzxid());
        Assert.assertNotSame((Object)stat.getCtime(), (Object)stat.getMtime());
        Assert.assertEquals((long)0L, (long)stat.getCversion());
        Assert.assertEquals((long)1L, (long)stat.getVersion());
        Assert.assertEquals((long)0L, (long)stat.getAversion());
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        Assert.assertEquals((long)(name.length() * 2), (long)stat.getDataLength());
        Assert.assertEquals((long)0L, (long)stat.getNumChildren());
    }
}

