/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudConfigurationPage;
import org.eclipse.gyrex.admin.ui.cloud.internal.ConnectToCloudDialog;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutFactory;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.FormTextDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGateListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NodeConnectionSection
extends SectionPart {
    private StringDialogField nodeIdField;
    private FormTextDialogField membershipStatusField;
    private final ZooKeeperGateListener listener = new ZooKeeperGateListener(){

        public void gateDown(ZooKeeperGate gate) {
            NodeConnectionSection.this.markStale();
        }

        public void gateRecovering(ZooKeeperGate gate) {
            NodeConnectionSection.this.markStale();
        }

        public void gateUp(ZooKeeperGate gate) {
            NodeConnectionSection.this.markStale();
        }
    };

    public NodeConnectionSection(CloudConfigurationPage page, Composite parent) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.createContent(this.getSection(), page.getManagedForm().getToolkit());
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    private void createContent(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        section.setText("Node Information");
        section.setDescription("This section describes the general information about the local node.");
        Composite client = toolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        this.nodeIdField = new StringDialogField(){

            protected Text createTextControl(Composite parent) {
                return new Text(parent, 2060);
            }
        };
        this.nodeIdField.setLabelText("Node Id");
        this.membershipStatusField = new FormTextDialogField();
        this.membershipStatusField.setLabelText("Membership");
        LayoutUtil.doDefaultLayout((Composite)client, (DialogField[])new DialogField[]{this.nodeIdField, this.membershipStatusField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nodeIdField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.membershipStatusField.getTextControl(null));
        this.membershipStatusField.adaptToForm(toolkit);
        this.membershipStatusField.getTextControl(null).addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if ("#connect".equals(e.getHref())) {
                    NodeConnectionSection.this.showConnectDialog();
                } else if ("#disconnect".equals(e.getHref())) {
                    NodeConnectionSection.this.disconnectNode();
                }
            }
        });
    }

    void disconnectNode() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(cloudManager.getLocalInfo().getNodeId());
        IStatus status = nodeConfigurer.configureConnection(null);
        if (!status.isOK()) {
            Policy.getStatusHandler().show(status, "Error Disconnecting Node");
            return;
        }
        this.markStale();
    }

    public void dispose() {
        ZooKeeperGate.removeConnectionMonitor((ZooKeeperGateListener)this.listener);
        super.dispose();
    }

    protected ICloudManager getCloudManager() {
        return (ICloudManager)this.getManagedForm().getInput();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        ZooKeeperGate.addConnectionMonitor((ZooKeeperGateListener)this.listener);
    }

    public void refresh() {
        ICloudManager cloudManager = this.getCloudManager();
        INodeEnvironment localInfo = cloudManager.getLocalInfo();
        INodeConfigurer nodeConfigurer = cloudManager.getNodeConfigurer(localInfo.getNodeId());
        this.nodeIdField.setText(localInfo.getNodeId());
        if (localInfo.inStandaloneMode()) {
            this.membershipStatusField.setText("<form><p>The node operates standalone. <a href=\"#connect\">Connect</a> it now.</p></form>", true, false);
        } else {
            String serverInfo;
            try {
                serverInfo = ZooKeeperGate.get().getConnectedServerInfo();
            }
            catch (Exception exception) {
                serverInfo = null;
            }
            String connectString = StringUtils.trimToEmpty((String)nodeConfigurer.getConnectionString());
            if (serverInfo != null) {
                this.membershipStatusField.setText(String.format("<form><p>The node is connected to %s (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a></p></form>", serverInfo, StringEscapeUtils.escapeXml((String)connectString)), true, false);
            } else {
                this.membershipStatusField.setText(String.format("<form><p>The node is currently not connected (using connect string '%s'). <a href=\"#disconnect\">Disconnect it.</a></p></form>", StringEscapeUtils.escapeXml((String)connectString)), true, false);
            }
        }
        super.refresh();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ICloudManager) {
            this.markStale();
            return true;
        }
        return super.setFormInput(input);
    }

    void showConnectDialog() {
        ConnectToCloudDialog connectToCloudDialog = new ConnectToCloudDialog(this.getCloudManager(), SwtUtil.getShell((Widget)this.membershipStatusField.getTextControl(null)));
        if (connectToCloudDialog.open() == 0) {
            this.markStale();
        }
    }
}

