/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import ch.qos.logback.classic.Level;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggerAppenderRef;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;
import org.eclipse.gyrex.logback.config.internal.model.Logger;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class LogbackConfigContentProvider
implements ITreeContentProvider {
    public static final Object[] NO_CHILDREN = new Object[0];

    public void dispose() {
    }

    public Object[] getChildren(Object o) {
        if (o instanceof LogbackConfig) {
            LogbackConfig logbackConfig = (LogbackConfig)o;
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(logbackConfig.getAppenders().values());
            children.addAll(logbackConfig.getLoggers().values());
            children.add(new DefaultLogger(logbackConfig));
            return children.toArray(new Object[children.size()]);
        }
        if (o instanceof Logger) {
            Logger logger = (Logger)o;
            List appenderReferences = logger.getAppenderReferences();
            Object[] children = new Object[appenderReferences.size()];
            int i = 0;
            while (i < children.length) {
                children[i] = new LoggerAppenderRef(logger, (String)appenderReferences.get(i));
                ++i;
            }
            return children;
        }
        if (o instanceof DefaultLogger) {
            DefaultLogger logger = (DefaultLogger)o;
            return logger.getAppenderReferences().toArray();
        }
        return NO_CHILDREN;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static class DefaultLogger {
        private final LogbackConfig config;

        public DefaultLogger(LogbackConfig logbackConfig) {
            this.config = logbackConfig;
        }

        public List<String> getAppenderReferences() {
            return this.config.getDefaultAppenders();
        }

        public Level getLevel() {
            return this.config.getDefaultLevel();
        }
    }
}

