/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import java.util.Collection;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutDataFactory;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.logback.internal.AddAppenderDialog;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackConfigContentProvider;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackLabelProvider;
import org.eclipse.gyrex.admin.ui.logback.internal.LogbackViewerComperator;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggerAppenderRef;
import org.eclipse.gyrex.admin.ui.logback.internal.LoggerSettingsDialog;
import org.eclipse.gyrex.logback.config.internal.PreferenceBasedLogbackConfigStore;
import org.eclipse.gyrex.logback.config.internal.model.Appender;
import org.eclipse.gyrex.logback.config.internal.model.LogbackConfig;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackSection
extends ViewerWithButtonsSectionPart {
    private static final Logger LOG = LoggerFactory.getLogger(LogbackSection.class);
    private TreeViewer configTree;
    private LogbackConfig currentInput;
    private Button editLoggerButton;
    private Button removeButton;
    private Object selectedElement;

    public LogbackSection(Composite parent, ConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        Section section = this.getSection();
        section.setText("Configuration");
        section.setDescription("Browse and modify the logback configuration.");
        this.createContent(section);
    }

    void addAppenderButtonPressed() {
        AddAppenderDialog dialog = new AddAppenderDialog(this.configTree.getTree().getShell());
        if (dialog.open() == 0) {
            this.currentInput.addAppender(dialog.getAppender());
            this.markDirty();
            this.configTree.refresh();
        }
    }

    void addLoggerButtonPressed() {
        LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.configTree.getTree().getShell(), this.currentInput.getAppenders().values());
        if (dialog.open() == 0) {
            this.currentInput.addLogger(dialog.getLogger());
            this.markDirty();
            this.configTree.refresh();
        }
    }

    public void commit(boolean onSave) {
        if (onSave) {
            IEclipsePreferences node = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config");
            try {
                Preferences configNode = node.node("config");
                new PreferenceBasedLogbackConfigStore().saveConfig(this.currentInput, configNode);
                node.putLong("lastModified", System.currentTimeMillis());
                node.flush();
            }
            catch (BackingStoreException e) {
                LOG.error("Error saving config!", (Throwable)e);
                return;
            }
            super.commit(onSave);
            this.getManagedForm().dirtyStateChanged();
        }
    }

    protected void createButtons(Composite buttonsPanel) {
        this.createButton(buttonsPanel, "Add Appender...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogbackSection.this.addAppenderButtonPressed();
            }
        });
        this.createButton(buttonsPanel, "Add Logger...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogbackSection.this.addLoggerButtonPressed();
            }
        });
        this.editLoggerButton = this.createButton(buttonsPanel, "Edit Logger...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogbackSection.this.editLoggerButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogbackSection.this.removeButtonPressed();
            }
        });
        Label separator = this.getToolkit().createLabel(buttonsPanel, "");
        FormLayoutDataFactory.applyDefaults((Label)separator, (int)1);
        this.createButton(buttonsPanel, "Edit Default Logger...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogbackSection.this.editDefaultLoggerButtonPressed();
            }
        });
        this.updateButtons();
    }

    protected void createViewer(Composite parent) {
        this.configTree = new TreeViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        Tree tree = this.configTree.getTree();
        this.getToolkit().adapt((Control)tree, true, true);
        tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.configTree.setContentProvider((IContentProvider)new LogbackConfigContentProvider());
        this.configTree.setLabelProvider((IBaseLabelProvider)new LogbackLabelProvider());
        this.configTree.setComparator((ViewerComparator)new LogbackViewerComperator());
        this.configTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogbackSection.this.updateSelectedElement(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.configTree.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                LogbackSection.this.updateSelectedElement(((IStructuredSelection)event.getSelection()).getFirstElement());
                LogbackSection.this.editSelectedElement();
            }
        });
    }

    void editDefaultLoggerButtonPressed() {
        LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.configTree.getTree().getShell(), this.currentInput.getDefaultLevel(), this.currentInput.getDefaultAppenders(), this.currentInput.getAppenders().values());
        if (dialog.open() == 0) {
            this.currentInput.setDefaultLevel(dialog.getLogger().getLevel());
            this.currentInput.setDefaultAppenders(dialog.getLogger().getAppenderReferences());
            this.markDirty();
            this.configTree.refresh();
        }
    }

    void editLoggerButtonPressed() {
        if (!(this.selectedElement instanceof org.eclipse.gyrex.logback.config.internal.model.Logger)) {
            return;
        }
        org.eclipse.gyrex.logback.config.internal.model.Logger logger = (org.eclipse.gyrex.logback.config.internal.model.Logger)this.selectedElement;
        String originalName = logger.getName();
        LoggerSettingsDialog dialog = new LoggerSettingsDialog(this.configTree.getTree().getShell(), originalName, logger.getLevel(), logger.isInheritOtherAppenders(), logger.getAppenderReferences(), this.currentInput.getAppenders().values());
        if (dialog.open() == 0) {
            this.currentInput.getLoggers().remove(originalName);
            this.currentInput.addLogger(dialog.getLogger());
            this.markDirty();
            this.configTree.refresh();
        }
    }

    void editSelectedElement() {
        if (this.selectedElement == null) {
            return;
        }
        if (this.selectedElement instanceof org.eclipse.gyrex.logback.config.internal.model.Logger) {
            this.editLoggerButtonPressed();
        } else if (this.selectedElement instanceof LogbackConfigContentProvider.DefaultLogger) {
            this.editDefaultLoggerButtonPressed();
        } else {
            boolean cfr_ignored_0 = this.selectedElement instanceof Appender;
        }
    }

    public ISelectionProvider getSelectionProvider() {
        return this.configTree;
    }

    public void refresh() {
        if (this.currentInput == null) {
            IEclipsePreferences node = CloudScope.INSTANCE.getNode("org.eclipse.gyrex.logback.config");
            try {
                if (node.nodeExists("config")) {
                    Preferences configNode = node.node("config");
                    configNode.sync();
                    this.currentInput = new PreferenceBasedLogbackConfigStore().loadConfig(configNode);
                } else {
                    this.currentInput = new LogbackConfig();
                }
            }
            catch (BackingStoreException e) {
                LOG.error("Error loading config!", (Throwable)e);
                this.currentInput = new LogbackConfig();
            }
            this.configTree.setInput((Object)this.currentInput);
        } else {
            this.configTree.refresh();
        }
        super.refresh();
    }

    void removeButtonPressed() {
        if (this.selectedElement == null) {
            return;
        }
        if (this.selectedElement instanceof LoggerAppenderRef) {
            LoggerAppenderRef appenderRef = (LoggerAppenderRef)this.selectedElement;
            appenderRef.getLogger().getAppenderReferences().remove(appenderRef.getAppenderRef());
        } else if (this.selectedElement instanceof org.eclipse.gyrex.logback.config.internal.model.Logger) {
            this.currentInput.getLoggers().remove(((org.eclipse.gyrex.logback.config.internal.model.Logger)this.selectedElement).getName());
        } else if (this.selectedElement instanceof Appender) {
            String appenderName = ((Appender)this.selectedElement).getName();
            Collection loggers = this.currentInput.getLoggers().values();
            for (org.eclipse.gyrex.logback.config.internal.model.Logger logger : loggers) {
                logger.getAppenderReferences().remove(appenderName);
            }
            this.currentInput.getAppenders().remove(appenderName);
        }
        this.markDirty();
        this.configTree.refresh();
    }

    private void updateButtons() {
        this.removeButton.setEnabled(this.selectedElement != null && !(this.selectedElement instanceof LogbackConfigContentProvider.DefaultLogger));
        this.editLoggerButton.setEnabled(this.selectedElement instanceof org.eclipse.gyrex.logback.config.internal.model.Logger);
    }

    void updateSelectedElement(Object firstElement) {
        this.selectedElement = firstElement;
        this.updateButtons();
    }
}

