/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jetty.internal.handlers;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.gyrex.http.jetty.internal.HttpJettyActivator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.StringUtil;

public class DefaultFaviconHandler
extends AbstractHandler {
    private static final String FAVICON_ICO_URI = "/favicon.ico";
    private final byte[] iconBytes = HttpJettyActivator.readBundleResource("/images/eclipse.ico");
    private final long iconModified = System.currentTimeMillis() / 1000L * 1000L;

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        if (this.iconBytes != null && "GET".equals(request.getMethod()) && StringUtil.endsWithIgnoreCase((String)request.getRequestURI(), (String)FAVICON_ICO_URI)) {
            baseRequest.setHandled(true);
            if (request.getDateHeader("If-Modified-Since") == this.iconModified) {
                response.setStatus(304);
            } else {
                response.setStatus(200);
                response.setContentType("image/x-icon");
                response.setContentLength(this.iconBytes.length);
                response.setDateHeader("Last-Modified", this.iconModified);
                response.setHeader("Cache-Control", "max-age=360000,public");
                response.getOutputStream().write(this.iconBytes);
            }
            return;
        }
    }
}

