/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal.httpservice;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.http.application.Application;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.httpservice.HttpServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public class HttpServiceApp
extends Application
implements ServiceFactory<HttpService> {
    private ServiceRegistration serviceRegistration;
    private Filter filter;

    public HttpServiceApp(String id, IRuntimeContext context) {
        super(id, context);
    }

    @Override
    protected void doDestroy() {
        this.serviceRegistration.unregister();
        this.serviceRegistration = null;
        this.filter = null;
    }

    @Override
    protected void doInit() throws Exception {
        Hashtable<String, String> props;
        String filterStr = this.getApplicationContext().getInitProperties().get("filter");
        if (filterStr != null) {
            try {
                this.filter = FrameworkUtil.createFilter((String)filterStr);
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalArgumentException(String.format("The specified filter '%s' is invalid. Please check the application configuration. %s", filterStr, e.getMessage()), e);
            }
        }
        if (((Dictionary)(props = new Hashtable<String, String>(this.getApplicationContext().getInitProperties()))).get("service.description") == null) {
            ((Dictionary)props).put("service.description", "Gyrex web application based OSGi HttpService");
        }
        if (((Dictionary)props).get("service.vendor") == null) {
            ((Dictionary)props).put("service.vendor", "Eclipse Gyrex");
        }
        if (((Dictionary)props).get("service.pid") == null) {
            ((Dictionary)props).put("service.pid", "org.eclipse.gyrex.http".concat(".service-").concat(this.getId()));
        }
        this.serviceRegistration = HttpActivator.getInstance().getBundle().getBundleContext().registerService(new String[]{HttpService.class.getName(), ExtendedHttpService.class.getName()}, (Object)this, props);
    }

    public HttpService getService(Bundle bundle, ServiceRegistration<HttpService> registration) {
        return new HttpServiceImpl(this.getApplicationContext(), bundle, this.filter);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<HttpService> registration, HttpService service) {
        ((HttpServiceImpl)service).unregisterAll();
    }
}

