/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.manager;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.jobs.history.IJobHistoryEntry;

public class JobHistoryItemImpl
implements IJobHistoryEntry {
    private final IStatus result;
    private final long timestamp;
    private final String queuedTrigger;
    private final String cancelledTrigger;
    private final Map<String, String> parameter;

    JobHistoryItemImpl(long timestamp, IStatus result, String queuedTrigger, String cancelledTrigger, Map<String, String> parameter) {
        this.timestamp = timestamp;
        this.result = result;
        this.queuedTrigger = queuedTrigger;
        this.cancelledTrigger = cancelledTrigger;
        this.parameter = parameter;
    }

    @Override
    public int compareTo(IJobHistoryEntry o) {
        long otherTimeStamp = o.getTimeStamp();
        if (otherTimeStamp > this.timestamp) {
            return 1;
        }
        if (otherTimeStamp < this.timestamp) {
            return -1;
        }
        if (o.getResult().getSeverity() == this.result.getSeverity()) {
            return this.result.getMessage().compareTo(o.getResult().getMessage());
        }
        return this.result.getSeverity() > o.getResult().getSeverity() ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobHistoryItemImpl other = (JobHistoryItemImpl)obj;
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (!this.result.getMessage().equals(other.result.getMessage())) {
            return false;
        }
        return this.result.getSeverity() == other.result.getSeverity();
    }

    @Override
    public String getCancelledTrigger() {
        return this.cancelledTrigger;
    }

    @Override
    public Map<String, String> getParameter() {
        Map<String, String> map = this.parameter;
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public String getQueuedTrigger() {
        return this.queuedTrigger;
    }

    @Override
    public IStatus getResult() {
        return this.result;
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.result.getMessage().hashCode();
        result = 31 * result + this.result.getSeverity();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(DateFormatUtils.SMTP_DATETIME_FORMAT.format(this.timestamp)).append(" ");
        switch (this.result.getSeverity()) {
            case 0: {
                builder.append("OK");
                break;
            }
            case 4: {
                builder.append("ERROR");
                break;
            }
            case 2: {
                builder.append("WARNING");
                break;
            }
            case 1: {
                builder.append("INFO");
                break;
            }
            case 8: {
                builder.append("CANCEL");
                break;
            }
            default: {
                builder.append("severity=");
                builder.append(this.result.getSeverity());
            }
        }
        if (StringUtils.isNotBlank((String)this.result.getMessage())) {
            builder.append(" ").append(StringUtils.replaceChars((String)CharSetUtils.delete((String)this.result.getMessage(), (String)"\t\r\b"), (char)'\n', (char)'|'));
        }
        return builder.toString();
    }
}

