/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.scheduler;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.scheduler.Schedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler
extends Job
implements IEclipsePreferences.INodeChangeListener {
    private static final String SCHEDULER_LOCK = "org.eclipse.gyrex.jobs.scheduler";
    private static final long INITIAL_SLEEP_TIME = TimeUnit.SECONDS.toMillis(30L);
    private static final long MAX_SLEEP_TIME = TimeUnit.MINUTES.toMillis(5L);
    private static final Logger LOG = LoggerFactory.getLogger(Scheduler.class);
    private long engineSleepTime = INITIAL_SLEEP_TIME;
    private final ConcurrentMap<String, Schedule> schedulesById = new ConcurrentHashMap<String, Schedule>();

    public Scheduler() {
        super("Gyrex Scheduler");
        this.setSystem(true);
        this.setPriority(20);
    }

    public void added(IEclipsePreferences.NodeChangeEvent event) {
        try {
            this.addSchedule(event.getChild().name());
        }
        catch (Exception e) {
            LOG.error("Unable to start schedule {}. {}", new Object[]{event.getChild().name(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    private void addSchedule(String scheduleStoreStorageKey) throws Exception {
        Schedule schedule;
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Adding schedule {}...", (Object)scheduleStoreStorageKey);
        }
        if (this.schedulesById.putIfAbsent(scheduleStoreStorageKey, schedule = new Schedule(scheduleStoreStorageKey, this)) == null) {
            schedule.start();
        }
    }

    /*
     * Exception decompiling
     */
    private IStatus doRun(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removed(IEclipsePreferences.NodeChangeEvent event) {
        try {
            this.removeSchedule(event.getChild().name());
        }
        catch (Exception e) {
            LOG.error("Unable to stop schedule {}. {}", (Object)event.getChild().name(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void removeSchedule(String id) {
        Schedule schedule;
        if (JobsDebug.schedulerEngine) {
            LOG.debug("Removing schedule {}...", (Object)id);
        }
        if ((schedule = (Schedule)this.schedulesById.remove(id)) == null) {
            return;
        }
        schedule.stop();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IStatus status = this.doRun(monitor);
            this.engineSleepTime = !status.isOK() ? Math.min(this.engineSleepTime * 2L, MAX_SLEEP_TIME) : INITIAL_SLEEP_TIME;
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            if (!monitor.isCanceled()) {
                if (JobsDebug.schedulerEngine) {
                    LOG.debug("Rescheduling scheduler engine to run again in {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(this.engineSleepTime));
                }
                this.schedule(this.engineSleepTime);
            }
        }
    }
}

