/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.internal.solr.facets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.gyrex.search.ISearchManager;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.query.FacetSelectionStrategy;
import org.eclipse.gyrex.search.query.TermCombination;
import org.eclipse.gyrex.search.solr.BaseSolrSearchManager;
import org.eclipse.osgi.util.NLS;

public class Facet
extends PlatformObject
implements IFacet {
    private final String attributeId;
    private final BaseSolrSearchManager manager;
    private final Map<Locale, String> names;
    private TermCombination termCombination;
    private FacetSelectionStrategy selectionStrategy;
    private boolean enabled = true;

    public Facet(String attributeId, BaseSolrSearchManager manager) {
        this(attributeId, manager, null);
    }

    public Facet(String attributeId, BaseSolrSearchManager manager, byte[] bytes) {
        this.attributeId = attributeId;
        this.manager = manager;
        this.names = new HashMap<Locale, String>(1);
        if (bytes != null) {
            this.initializeFromByteArray(bytes);
        }
    }

    @Override
    public String getAttributeId() {
        return this.attributeId;
    }

    public ISearchManager getManager() throws IllegalStateException {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.getName(Locale.ROOT);
    }

    @Override
    public String getName(Locale ... localeLookupList) {
        Locale[] localeArray = localeLookupList;
        int n = localeLookupList.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = localeArray[n2];
            String name = this.names.get(locale);
            if (name != null) {
                return name;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Map<Locale, String> getNames() {
        return Collections.unmodifiableMap(this.names);
    }

    @Override
    public FacetSelectionStrategy getSelectionStrategy() {
        return this.selectionStrategy;
    }

    @Override
    public TermCombination getTermCombination() {
        return this.termCombination;
    }

    private void initializeFromByteArray(byte[] bytes) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Map readNames = (Map)in.readObject();
            if (readNames != null) {
                for (Map.Entry entry : readNames.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(key instanceof Locale) || !(value instanceof String)) continue;
                    this.names.put((Locale)key, (String)value);
                }
            }
            this.enabled = in.readBoolean();
            this.termCombination = (TermCombination)((Object)in.readObject());
            this.selectionStrategy = (FacetSelectionStrategy)((Object)in.readObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(NLS.bind((String)"Error while serializing facet {0}. {1}", (Object)this.attributeId, (Object)e.getMessage()), e);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setName(String name) {
        this.setName(name, Locale.ROOT);
    }

    @Override
    public void setName(String name, Locale locale) {
        if (name != null) {
            if (locale == null) {
                throw new IllegalArgumentException("locale must not be null if a name is provided");
            }
            this.names.put(locale, name);
        } else if (locale != null) {
            this.names.remove(locale);
        } else {
            this.names.clear();
        }
    }

    @Override
    public void setSelectionStrategy(FacetSelectionStrategy strategy) {
        this.selectionStrategy = strategy;
    }

    @Override
    public void setTermCombination(TermCombination combination) {
        this.termCombination = combination;
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(this.names);
            out.writeBoolean(this.enabled);
            out.writeObject((Object)this.termCombination);
            out.writeObject((Object)this.selectionStrategy);
            return bytes.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(NLS.bind((String)"Error while serializing facet {0}. {1}", (Object)this.attributeId, (Object)e.getMessage()), e);
        }
    }
}

