/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.FunctionalExpressionNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;

public class FuncNode
extends FunctionalExpressionNode {
    private String name;
    private List<Node> parameters;

    protected FuncNode() {
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParameters(List parameters) {
        this.parameters = parameters;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void validate(ParseTreeContext context) {
        for (Node parameter : this.parameters) {
            parameter.validate(context);
        }
    }

    public Expression generateExpression(GenerationContext context) {
        int size = this.parameters.size();
        if (size == 0) {
            return context.getBaseExpression().getFunction(this.name);
        }
        ArrayList<Expression> vExpressions = new ArrayList<Expression>(size - 1);
        Expression base = this.parameters.get(0).generateExpression(context);
        int i = 1;
        while (i < size) {
            Expression child = this.parameters.get(i).generateExpression(context);
            vExpressions.add(child);
            ++i;
        }
        Expression expression = base.getFunctionWithArguments(this.name, vExpressions);
        return expression;
    }
}

