/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLReaderAdapter
extends XMLReader {
    protected ExtendedContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    protected LexicalHandler lexicalHandler;

    public XMLReaderAdapter() {
    }

    public XMLReaderAdapter(XMLUnmarshaller xmlUnmarshaller) {
        if (xmlUnmarshaller != null) {
            Schema schema = xmlUnmarshaller.getSchema();
            if (schema != null) {
                this.validatingContentHandler = new XMLReader.ValidatingContentHandler(schema.newValidatorHandler());
                this.contentHandler = new ExtendedContentHandlerAdapter(this.validatingContentHandler);
            }
            this.setErrorHandler(xmlUnmarshaller.getErrorHandler());
        }
    }

    public ExtendedContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        if (this.validatingContentHandler == null) {
            this.contentHandler = contentHandler instanceof ExtendedContentHandler ? (ExtendedContentHandler)contentHandler : new ExtendedContentHandlerAdapter(contentHandler);
        } else {
            this.validatingContentHandler.setContentHandler(contentHandler);
        }
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        if (this.validatingContentHandler != null) {
            this.validatingContentHandler.setErrorHandler(errorHandler);
        }
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            return this.getLexicalHandler();
        }
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/properties/lexical-handler".equals(name)) {
            this.setLexicalHandler((LexicalHandler)value);
        }
    }

    public void parse(String systemId) {
    }

    protected static class Attribute {
        private String localName;
        private String uri;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.localName = localName;
            this.uri = uri == null ? "" : uri;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getLocalName() {
            return this.localName;
        }

        public String getUri() {
            return this.uri;
        }
    }

    private static class ExtendedContentHandlerAdapter
    implements ExtendedContentHandler {
        private ContentHandler contentHandler;

        public ExtendedContentHandlerAdapter(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }

        public void setDocumentLocator(Locator locator) {
            this.contentHandler.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            this.contentHandler.startDocument();
        }

        public void endDocument() throws SAXException {
            this.contentHandler.endDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.contentHandler.endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.contentHandler.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.contentHandler.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.contentHandler.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        public void characters(CharSequence characters) throws SAXException {
            if (characters == null) {
                return;
            }
            this.contentHandler.characters(characters.toString().toCharArray(), 0, characters.length());
        }
    }

    protected static abstract class IndexedAttributeList
    implements Attributes {
        protected static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
        protected Attribute[] attributes;

        protected IndexedAttributeList() {
        }

        protected abstract Attribute[] attributes();

        public int getIndex(String qName) {
            if (qName == null) {
                return -1;
            }
            int index = 0;
            Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            if (localName == null) {
                return -1;
            }
            int index = 0;
            new QName(uri, localName);
            Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        public int getLength() {
            return this.attributes().length;
        }

        public String getLocalName(int index) {
            return this.attributes()[index].getLocalName();
        }

        public String getQName(int index) {
            return this.attributes()[index].getName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String name) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getURI(int index) {
            return this.attributes()[index].getUri();
        }

        public String getValue(int index) {
            return this.attributes()[index].getValue();
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes()[index].getValue();
        }

        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (-1 == index) {
                return null;
            }
            return this.attributes()[index].getValue();
        }

        public IndexedAttributeList reset() {
            this.attributes = null;
            return this;
        }
    }
}

