/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRInputStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.ANTLRReaderStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.RecognitionException;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenRewriteStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenSource;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.json.JSONLexer;
import org.eclipse.persistence.internal.oxm.record.json.JSONParser;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JSONReader
extends XMLReaderAdapter {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private Properties properties;
    private String attributePrefix = null;
    private NamespaceResolver namespaces = null;
    protected boolean includeRoot;
    private JSONAttributes attributes = new JSONAttributes();

    public JSONReader(String attrPrefix, NamespaceResolver nr, boolean namespaceAware, boolean includeRoot) {
        this(attrPrefix, nr, namespaceAware, includeRoot, '.');
    }

    public JSONReader(String attrPrefix, NamespaceResolver nr, boolean namespaceAware, boolean includeRoot, char namespaceSeparator) {
        this.attributePrefix = attrPrefix;
        if (this.attributePrefix == "") {
            this.attributePrefix = null;
        }
        this.namespaces = nr;
        this.namespaceAware = namespaceAware;
        this.namespaceSeparator = namespaceSeparator;
        this.includeRoot = includeRoot;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        try {
            ANTLRInputStream charStream;
            InputStream inputStream = null;
            if (input.getByteStream() != null) {
                charStream = new ANTLRInputStream(input.getByteStream());
            } else if (input.getCharacterStream() != null) {
                charStream = new ANTLRReaderStream(input.getCharacterStream());
            } else {
                URL url = new URL(input.getSystemId());
                inputStream = url.openStream();
                charStream = new ANTLRInputStream(inputStream);
            }
            JSONLexer lexer = new JSONLexer((CharStream)charStream);
            TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
            JSONParser parser = new JSONParser((TokenStream)tokens);
            CommonTree commonTree = (CommonTree)parser.message().getTree();
            this.parseRoot((Tree)commonTree);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (RecognitionException e) {
            throw new SAXParseException(e.getLocalizedMessage(), input.getPublicId(), input.getSystemId(), e.line, e.index, (Exception)((Object)e));
        }
    }

    private void parseRoot(Tree tree) throws SAXException {
        if (this.namespaces != null) {
            Map<String, String> namespacePairs = this.namespaces.getPrefixesToNamespaces();
            for (String nextKey : namespacePairs.keySet()) {
                this.contentHandler.startPrefixMapping(nextKey, namespacePairs.get(nextKey));
            }
        }
        if (tree.getType() == 16) {
            this.contentHandler.startDocument();
            tree.getChildCount();
            if (this.includeRoot) {
                this.parse((Tree)((CommonTree)tree.getChild(0)));
            } else {
                this.contentHandler.startElement("", "", null, this.attributes.setTree(tree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                int x = 0;
                int size = tree.getChildCount();
                while (x < size) {
                    this.parse((Tree)((CommonTree)tree.getChild(x)));
                    ++x;
                }
                this.contentHandler.endElement("", "", null);
            }
            this.contentHandler.endDocument();
        } else if (tree.getType() == 4) {
            int size = tree.getChildCount();
            ArrayList<Object> list = new ArrayList<Object>(size);
            int x = 0;
            while (x < size) {
                this.parseRoot(tree.getChild(x));
                if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = (SAXUnmarshallerHandler)this.contentHandler;
                    list.add(saxUnmarshallerHandler.getObject());
                    saxUnmarshallerHandler.setObject(null);
                } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                    UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.contentHandler;
                    list.add(unmarshalRecord.getCurrentObject());
                    unmarshalRecord.setCurrentObject(null);
                }
                ++x;
            }
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                ((SAXUnmarshallerHandler)this.getContentHandler()).setObject(list);
            } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                ((UnmarshalRecord)this.getContentHandler()).setCurrentObject(list);
            }
        }
    }

    private void parse(Tree tree) throws SAXException {
        switch (tree.getType()) {
            case 17: {
                int nsIndex;
                Tree valueTree = tree.getChild(1);
                if (valueTree.getType() == 4) {
                    this.parse(valueTree);
                    break;
                }
                Tree stringTree = tree.getChild(0);
                String localName = stringTree.getText().substring(1, stringTree.getText().length() - 1);
                if (this.attributePrefix != null && localName.startsWith(this.attributePrefix)) break;
                String uri = "";
                if (this.namespaceAware && this.namespaces != null && (nsIndex = localName.indexOf(this.namespaceSeparator)) > -1) {
                    String prefix = localName.substring(0, nsIndex);
                    localName = localName.substring(nsIndex + 1);
                    uri = this.namespaces.resolveNamespacePrefix(prefix);
                }
                this.contentHandler.startElement(uri, localName, localName, this.attributes.setTree(valueTree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                this.parse(valueTree);
                this.contentHandler.endElement(uri, localName, localName);
                break;
            }
            case 18: {
                String string = this.string(tree.getChild(0).getText());
                this.contentHandler.characters(string);
                break;
            }
            case 14: {
                this.contentHandler.characters(tree.getChild(0).getText());
                break;
            }
            case 20: {
                this.contentHandler.characters(TRUE);
                break;
            }
            case 9: {
                this.contentHandler.characters(FALSE);
                break;
            }
            case 13: {
                break;
            }
            case 4: {
                int nsIndex;
                Tree parentStringTree = tree.getParent().getChild(0);
                String parentLocalName = parentStringTree.getText().substring(1, parentStringTree.getText().length() - 1);
                String uri = "";
                if (this.namespaceAware && this.namespaces != null && (nsIndex = parentLocalName.indexOf(this.namespaceSeparator)) > -1) {
                    String prefix = parentLocalName.substring(0, nsIndex);
                    parentLocalName = parentLocalName.substring(nsIndex + 1);
                    uri = this.namespaces.resolveNamespacePrefix(prefix);
                }
                int x = 0;
                int size = tree.getChildCount();
                while (x < size) {
                    CommonTree nextChildTree = (CommonTree)tree.getChild(x);
                    this.contentHandler.startElement(uri, parentLocalName, parentLocalName, this.attributes.setTree((Tree)nextChildTree, this.attributePrefix, this.namespaces, this.namespaceSeparator, this.namespaceAware));
                    this.parse((Tree)nextChildTree);
                    this.contentHandler.endElement(uri, parentLocalName, parentLocalName);
                    ++x;
                }
                break;
            }
            default: {
                int x = 0;
                int size = tree.getChildCount();
                while (x < size) {
                    this.parse((Tree)((CommonTree)tree.getChild(x)));
                    ++x;
                }
                break block0;
            }
        }
    }

    private String string(String string) {
        String subString;
        string = string.substring(1, string.length() - 1);
        String returnString = "";
        int slashIndex = string.indexOf(92);
        if (slashIndex == -1) {
            return string;
        }
        int position = 0;
        while (slashIndex > -1) {
            subString = string.substring(position, slashIndex);
            returnString = String.valueOf(returnString) + subString;
            position = slashIndex;
            char nextChar = string.charAt(slashIndex + 1);
            switch (nextChar) {
                case 'b': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\b';
                    break;
                }
                case 'r': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\r';
                    break;
                }
                case 'f': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\f';
                    break;
                }
                case 'n': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\n';
                    break;
                }
                case 't': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\t';
                    break;
                }
                case '\"': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\"';
                    break;
                }
                case '\\': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '\\';
                    break;
                }
                case '/': {
                    position += 2;
                    returnString = String.valueOf(returnString) + '/';
                    break;
                }
                case 'u': {
                    position += 6;
                    String hexValue = string.substring(slashIndex + 2, slashIndex + 6);
                    returnString = String.valueOf(returnString) + Character.toString((char)Integer.parseInt(hexValue, 16));
                }
            }
            slashIndex = string.indexOf(92, position);
        }
        if (position < string.length()) {
            subString = string.substring(position, string.length());
            returnString = String.valueOf(returnString) + subString;
        }
        return returnString;
    }

    private static class JSONAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private Tree tree;
        private String attributePrefix;
        private char namespaceSeparator;
        private NamespaceResolver namespaces;
        private boolean namespaceAware;

        private JSONAttributes() {
        }

        public JSONAttributes setTree(Tree tree, String attributePrefix, NamespaceResolver nr, char namespaceSeparator, boolean namespaceAware) {
            this.reset();
            this.tree = tree;
            this.attributePrefix = attributePrefix;
            this.namespaces = nr;
            this.namespaceSeparator = namespaceSeparator;
            this.namespaceAware = namespaceAware;
            return this;
        }

        private void addSimpleAttribute(List attributes, String uri, String attributeLocalName, Tree childValueTree) {
            switch (childValueTree.getType()) {
                case 18: {
                    String stringValue = childValueTree.getChild(0).getText();
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, stringValue.substring(1, stringValue.length() - 1)));
                    break;
                }
                case 14: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, childValueTree.getChild(0).getText()));
                    break;
                }
                case 20: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JSONReader.TRUE));
                    break;
                }
                case 9: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JSONReader.FALSE));
                    break;
                }
                case 13: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
                }
            }
        }

        public int getIndex(String uri, String localName) {
            if (localName == null) {
                return -1;
            }
            int index = 0;
            XMLReaderAdapter.Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLReaderAdapter.Attribute attribute = attributeArray[n2];
                if (this.namespaceAware) {
                    new QName(uri, localName);
                    if (localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri())) {
                        return index;
                    }
                } else if (attribute.getName().equals(localName)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                if (this.tree.getType() == 13) {
                    this.attributes = new XMLReaderAdapter.Attribute[1];
                    this.attributes[0] = new XMLReaderAdapter.Attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "nil", JSONReader.TRUE);
                    return this.attributes;
                }
                if (this.tree.getType() == 16) {
                    ArrayList attributesList = new ArrayList(this.tree.getChildCount());
                    int x = 0;
                    while (x < this.tree.getChildCount()) {
                        Tree childValueTree;
                        int nsIndex;
                        Tree childTree = this.tree.getChild(x);
                        String attributeLocalName = childTree.getChild(0).getText().substring(1, childTree.getChild(0).getText().length() - 1);
                        if (this.attributePrefix != null) {
                            if (!attributeLocalName.startsWith(this.attributePrefix)) break;
                            attributeLocalName = attributeLocalName.substring(this.attributePrefix.length());
                        }
                        String uri = "";
                        if (this.namespaceAware && this.namespaces != null && (nsIndex = attributeLocalName.indexOf(this.namespaceSeparator)) > -1) {
                            String prefix = attributeLocalName.substring(0, nsIndex);
                            attributeLocalName = attributeLocalName.substring(nsIndex + 1);
                            uri = this.namespaces.resolveNamespacePrefix(prefix);
                        }
                        if ((childValueTree = childTree.getChild(1)).getType() == 4) {
                            int y = 0;
                            int size = childValueTree.getChildCount();
                            while (y < size) {
                                CommonTree nextChildTree = (CommonTree)childValueTree.getChild(y);
                                this.addSimpleAttribute(attributesList, uri, attributeLocalName, (Tree)nextChildTree);
                                ++y;
                            }
                        } else {
                            this.addSimpleAttribute(attributesList, uri, attributeLocalName, childValueTree);
                        }
                        ++x;
                    }
                    this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                } else {
                    this.attributes = NO_ATTRIBUTES;
                }
            }
            return this.attributes;
        }
    }
}

