/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.transformers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class MethodBasedAttributeTransformer
implements AttributeTransformer {
    protected transient Method attributeTransformationMethod;
    protected AbstractTransformationMapping mapping;
    protected String methodName;

    public MethodBasedAttributeTransformer() {
    }

    public MethodBasedAttributeTransformer(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public Method getAttributeTransformationMethod() {
        return this.attributeTransformationMethod;
    }

    public void setAttributeTransformationMethod(Method theMethod) {
        this.attributeTransformationMethod = theMethod;
    }

    public void initialize(AbstractTransformationMapping mapping) {
        this.mapping = mapping;
        try {
            Class[] parameterTypes = new Class[]{ClassConstants.Record_Class};
            this.attributeTransformationMethod = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), this.methodName, parameterTypes);
        }
        catch (Exception exception) {
            try {
                Class[] parameterTypes = new Class[]{ClassConstants.Record_Class};
                this.attributeTransformationMethod = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), this.methodName, parameterTypes);
            }
            catch (Exception exception2) {
                try {
                    Class[] parameterTypes = new Class[]{ClassConstants.Record_Class, ClassConstants.PublicInterfaceSession_Class};
                    this.attributeTransformationMethod = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), this.methodName, parameterTypes);
                }
                catch (Exception exception3) {
                    try {
                        Class[] parameterTypes = new Class[]{ClassConstants.Record_Class, ClassConstants.SessionsSession_Class};
                        this.attributeTransformationMethod = Helper.getDeclaredMethod(mapping.getDescriptor().getJavaClass(), this.methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException exception4) {
                        throw DescriptorException.noSuchMethodOnInitializingAttributeMethod(mapping.getAttributeMethodName(), mapping, exception4);
                    }
                    catch (SecurityException exception5) {
                        throw DescriptorException.securityOnInitializingAttributeMethod(mapping.getAttributeMethodName(), mapping, exception5);
                    }
                }
            }
        }
        if (this.attributeTransformationMethod.getReturnType() == ClassConstants.Void_Class) {
            throw DescriptorException.returnTypeInGetAttributeAccessor(this.methodName, mapping);
        }
    }

    public Object buildAttributeValue(Record record, Object object, Session session) {
        Class[] parameterTypes = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                parameterTypes = (Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.attributeTransformationMethod));
            }
            catch (PrivilegedActionException ex) {
                throw (RuntimeException)ex.getCause();
            }
        } else {
            parameterTypes = PrivilegedAccessHelper.getMethodParameterTypes(this.attributeTransformationMethod);
        }
        Object[] parameters = new Object[parameterTypes.length];
        parameters[0] = record;
        if (parameters.length == 2) {
            parameters[1] = session;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.attributeTransformationMethod, object, parameters));
                }
                catch (PrivilegedActionException ex) {
                    if (ex.getCause() instanceof IllegalArgumentException) {
                        throw (IllegalArgumentException)ex.getCause();
                    }
                    if (ex.getCause() instanceof InvocationTargetException) {
                        throw (InvocationTargetException)ex.getCause();
                    }
                    throw (RuntimeException)ex.getCause();
                }
            }
            return PrivilegedAccessHelper.invokeMethod(this.attributeTransformationMethod, object, parameters);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileInvokingAttributeMethod(this.mapping, exception);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileInvokingAttributeMethod(this.mapping, exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileInvokingAttributeMethod(this.mapping, exception);
        }
    }
}

