/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAbstractAnyMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLAnyObjectMapping
extends XMLAbstractAnyMapping
implements XMLMapping {
    private XMLField field;
    private boolean useXMLRoot = false;
    private boolean areOtherMappingInThisContext = true;
    private XMLConverter converter;
    private boolean isMixedContent = true;

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        throw DescriptorException.invalidMappingOperation(this, "buildBackupClone");
    }

    public void buildClone(Object original, CacheKey cacheKey, Object clone, AbstractSession cloningSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildClone");
    }

    public void buildCloneFromRow(AbstractRecord databaseRow, JoinedAttributeManager joinManager, Object clone, CacheKey sharedCacheKey, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        throw DescriptorException.invalidMappingOperation(this, "buildCloneFromRow");
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public Object clone() {
        XMLAnyCollectionMapping mapping = null;
        mapping = (XMLAnyCollectionMapping)super.clone();
        mapping.setContainerPolicy(this.getContainerPolicy());
        mapping.setField(this.getField());
        return mapping;
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareForChange");
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        throw DescriptorException.invalidMappingOperation(this, "compareObjects");
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        throw DescriptorException.invalidMappingOperation(this, "fixObjectReferences");
    }

    public DatabaseField getField() {
        return this.field;
    }

    public void iterate(DescriptorIterator iterator) {
        throw DescriptorException.invalidMappingOperation(this, "iterate");
    }

    public void setXPath(String xpath) {
        this.field = new XMLField(xpath);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeChangesIntoObject");
    }

    public void mergeIntoObject(Object target, boolean isTargetUninitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        throw DescriptorException.invalidMappingOperation(this, "mergeIntoObject");
    }

    public void setField(DatabaseField field) {
        this.field = (XMLField)field;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        XMLRecord record = (XMLRecord)row;
        if (this.getField() != null) {
            Object nested = record.get(this.getField());
            if (nested instanceof Vector) {
                nested = ((Vector)nested).firstElement();
            }
            if (!(nested instanceof XMLRecord)) {
                return null;
            }
            record = (XMLRecord)nested;
        }
        return this.buildObjectValuesFromDOMRecord((DOMRecord)record, executionSession, sourceQuery, joinManager);
    }

    private Object buildObjectValuesFromDOMRecord(DOMRecord record, AbstractSession session, ObjectBuildingQuery query, JoinedAttributeManager joinManager) {
        Node root = record.getDOM();
        NodeList nodes = root.getChildNodes();
        ArrayList unmappedChildren = this.getUnmappedChildNodes(nodes);
        Iterator iter = unmappedChildren.iterator();
        int i = 0;
        int length = unmappedChildren.size();
        while (iter.hasNext()) {
            Object objectValue = null;
            Node next = (Node)iter.next();
            if (next.getNodeType() == 3) {
                if (i == length - 1 || next.getNodeValue().trim().length() > 0) {
                    objectValue = next.getNodeValue();
                    if (this.getConverter() != null) {
                        objectValue = this.getConverter().convertDataValueToObjectValue(objectValue, session, record.getUnmarshaller());
                    }
                    return objectValue;
                }
            } else if (next.getNodeType() == 1) {
                XMLDescriptor referenceDescriptor = null;
                DOMRecord nestedRecord = (DOMRecord)record.buildNestedRow((Element)next);
                if (!this.useXMLRoot) {
                    return this.buildObjectForNonXMLRoot(this.getDescriptor(nestedRecord, session, null), this.getConverter(), query, record, nestedRecord, joinManager, session, next, null, null);
                }
                String schemaType = ((Element)next).getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                QName schemaTypeQName = null;
                XPathFragment frag = new XPathFragment();
                if (schemaType != null && schemaType.length() > 0) {
                    frag.setXPath(schemaType);
                    if (frag.hasNamespace()) {
                        String prefix = frag.getPrefix();
                        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                        String url = xmlPlatform.resolveNamespacePrefix(next, prefix);
                        frag.setNamespaceURI(url);
                        schemaTypeQName = new QName(url, frag.getLocalName());
                    }
                    XMLContext xmlContext = nestedRecord.getUnmarshaller().getXMLContext();
                    referenceDescriptor = xmlContext.getDescriptorByGlobalType(frag);
                }
                if (referenceDescriptor == null) {
                    try {
                        referenceDescriptor = this.getDescriptor(nestedRecord, session, new QName(nestedRecord.getNamespaceURI(), nestedRecord.getLocalName()));
                    }
                    catch (XMLMarshalException xMLMarshalException) {
                        referenceDescriptor = null;
                    }
                }
                if (this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT || referenceDescriptor == null && this.getKeepAsElementPolicy() == UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT) {
                    Object objVal = this.buildObjectNoReferenceDescriptor(nestedRecord, this.getConverter(), session, next, null, null);
                    if (referenceDescriptor != null) {
                        return referenceDescriptor.wrapObjectInXMLRoot(objVal, next.getNamespaceURI(), next.getLocalName(), next.getPrefix(), false, record.isNamespaceAware());
                    }
                    return this.buildXMLRoot(next, objVal);
                }
                if (referenceDescriptor != null) {
                    return this.buildObjectAndWrapInXMLRoot(referenceDescriptor, this.getConverter(), query, record, nestedRecord, joinManager, session, next, null, null);
                }
                XMLRoot rootValue = this.buildXMLRootForText(next, schemaTypeQName, this.getConverter(), session, record);
                if (rootValue != null) {
                    return rootValue;
                }
            }
            ++i;
        }
        return null;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(object);
        if (attributeValue == null) {
            return;
        }
        this.writeSingleValue(attributeValue, object, (XMLRecord)row, session);
    }

    public void writeSingleValue(Object value, Object parent, XMLRecord row, AbstractSession session) {
        DOMRecord record = (DOMRecord)row;
        Node root = record.getDOM();
        Object objectValue = value;
        if (this.getConverter() != null) {
            objectValue = this.getConverter().convertObjectValueToDataValue(objectValue, session, row.getMarshaller());
        }
        if (this.field != null) {
            root = XPathEngine.getInstance().create((XMLField)this.getField(), root, session);
        }
        Document doc = record.getDocument();
        XMLField xmlRootField = null;
        boolean wasXMLRoot = false;
        Object originalObject = objectValue;
        Node toReplace = this.getNodeToReplace(root);
        if (this.usesXMLRoot() && objectValue instanceof XMLRoot) {
            xmlRootField = new XMLField();
            wasXMLRoot = true;
            XPathFragment frag = new XPathFragment();
            if (((XMLRoot)objectValue).getNamespaceURI() != null) {
                frag.setNamespaceURI(((XMLRoot)objectValue).getNamespaceURI());
            }
            frag.setXPath(((XMLRoot)objectValue).getLocalName());
            xmlRootField.setXPathFragment(frag);
            xmlRootField.setNamespaceResolver(row.getNamespaceResolver());
            objectValue = ((XMLRoot)objectValue).getObject();
        }
        if (objectValue instanceof String) {
            this.writeSimpleValue(xmlRootField, record, session, originalObject, objectValue, root, toReplace, wasXMLRoot);
        } else if (objectValue instanceof Node) {
            Node importedCopy = doc.importNode((Node)objectValue, true);
            root.appendChild(importedCopy);
        } else {
            DOMRecord nestedRecord;
            XMLDescriptor referenceDescriptor = (XMLDescriptor)session.getDescriptor(objectValue.getClass());
            if (referenceDescriptor == null) {
                this.writeSimpleValue(xmlRootField, record, session, originalObject, objectValue, root, toReplace, wasXMLRoot);
                return;
            }
            if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
                String prefix = referenceDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                if (prefix == null || prefix.length() == 0) {
                    prefix = row.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
                }
                if (prefix == null || prefix.length() == 0) {
                    xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                    prefix = row.getNamespaceResolver().generatePrefix();
                }
                xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
            }
            if ((nestedRecord = (DOMRecord)this.buildCompositeRow(objectValue, session, referenceDescriptor, row, xmlRootField, originalObject, wasXMLRoot)) != null && toReplace != null) {
                if (nestedRecord.getDOM() != toReplace) {
                    root.replaceChild(nestedRecord.getDOM(), toReplace);
                }
            } else if (nestedRecord != null) {
                root.appendChild(nestedRecord.getDOM());
            } else if (toReplace != null) {
                root.removeChild(toReplace);
            }
        }
    }

    protected AbstractRecord buildCompositeRow(Object attributeValue, AbstractSession session, XMLDescriptor referenceDescriptor, AbstractRecord parentRow, DatabaseField field, Object originalObject, boolean wasXMLRoot) {
        if (field == null && referenceDescriptor != null && referenceDescriptor.getDefaultRootElement() != null) {
            field = referenceDescriptor.buildField(referenceDescriptor.getDefaultRootElement());
        }
        if (field != null && referenceDescriptor != null) {
            ((XMLRecord)parentRow).setLeafElementType(referenceDescriptor.getDefaultRootElementType());
            XMLObjectBuilder objectBuilder = (XMLObjectBuilder)referenceDescriptor.getObjectBuilder();
            XMLRecord child = (XMLRecord)objectBuilder.createRecordFor(attributeValue, (XMLField)field, (XMLRecord)parentRow, this);
            child.setNamespaceResolver(((XMLRecord)parentRow).getNamespaceResolver());
            objectBuilder.buildIntoNestedRow(child, originalObject, attributeValue, session, referenceDescriptor, (XMLField)field, wasXMLRoot);
            return child;
        }
        return null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        if (this.getField() != null) {
            this.setField(this.getDescriptor().buildField(this.getField()));
        }
        if (this.converter != null) {
            this.converter.initialize(this, session);
        }
    }

    public boolean isXMLMapping() {
        return true;
    }

    public Vector getFields() {
        return this.collectFields();
    }

    public void setUseXMLRoot(boolean useXMLRoot) {
        this.useXMLRoot = useXMLRoot;
    }

    public boolean usesXMLRoot() {
        return this.useXMLRoot;
    }

    private ArrayList getUnmappedChildNodes(NodeList nodes) {
        ArrayList<Node> unmappedNodes = new ArrayList<Node>();
        int length = nodes.getLength();
        int i = 0;
        while (i < length) {
            Node next = nodes.item(i);
            if (this.isUnmappedContent(next)) {
                unmappedNodes.add(next);
            }
            ++i;
        }
        return unmappedNodes;
    }

    private XPathFragment getFragmentToCompare(XMLField field, XMLField context) {
        if (field == null) {
            return null;
        }
        if (context == null) {
            return field.getXPathFragment();
        }
        XPathFragment fieldFrag = field.getXPathFragment();
        for (XPathFragment contextFrag = context.getXPathFragment(); fieldFrag != null && contextFrag != null; contextFrag = contextFrag.getNextFragment(), fieldFrag = fieldFrag.getNextFragment()) {
            if (fieldFrag.equals(contextFrag)) {
                if (contextFrag.getNextFragment() != null) continue;
                return fieldFrag.getNextFragment();
            }
            return null;
        }
        return null;
    }

    private boolean isUnmappedContent(Node node) {
        if (!this.areOtherMappingInThisContext) {
            return true;
        }
        XMLDescriptor parentDesc = (XMLDescriptor)this.getDescriptor();
        XMLField field = (XMLField)this.getField();
        Iterator<DatabaseMapping> mappings = parentDesc.getMappings().iterator();
        int mappingsInContext = 0;
        while (mappings.hasNext()) {
            XMLField nextField;
            XPathFragment frag;
            DatabaseMapping next = mappings.next();
            if (next != this && (frag = this.getFragmentToCompare(nextField = (XMLField)next.getField(), field)) != null) {
                ++mappingsInContext;
                if ((node.getNodeType() == 3 || node.getNodeType() == 4) && frag.nameIsText()) {
                    return false;
                }
                if (node.getNodeType() == 1) {
                    String nodeNS = node.getNamespaceURI();
                    String fragNS = frag.getNamespaceURI();
                    String nodeLocalName = node.getLocalName();
                    String fragLocalName = frag.getLocalName();
                    if ((nodeNS == fragNS || nodeNS != null && fragNS != null && nodeNS.equals(fragNS)) && (nodeLocalName == fragLocalName || nodeLocalName != null && fragLocalName != null && nodeLocalName.equals(fragLocalName))) {
                        return false;
                    }
                }
            }
            if (mappingsInContext != 0) continue;
            this.areOtherMappingInThisContext = false;
        }
        return true;
    }

    public Node getNodeToReplace(Node parent) {
        Node next = parent.getFirstChild();
        while (next != null) {
            if ((next.getNodeType() == 1 || next.getNodeType() == 3 || next.getNodeType() == 4) && this.isUnmappedContent(next)) {
                return next;
            }
            next = next.getNextSibling();
        }
        return null;
    }

    private void writeSimpleValue(XMLField xmlRootField, DOMRecord row, AbstractSession session, Object originalObject, Object value, Node root, Node toReplace, boolean wasXMLRoot) {
        Document doc = row.getDocument();
        if (wasXMLRoot && ((XMLRoot)originalObject).getNamespaceURI() != null) {
            String prefix = row.getNamespaceResolver().resolveNamespaceURI(((XMLRoot)originalObject).getNamespaceURI());
            if (prefix == null || prefix.length() == 0) {
                xmlRootField.getXPathFragment().setGeneratedPrefix(true);
                prefix = row.getNamespaceResolver().generatePrefix();
            }
            xmlRootField.getXPathFragment().setXPath(String.valueOf(prefix) + ':' + ((XMLRoot)originalObject).getLocalName());
        }
        if (xmlRootField == null) {
            Text textNode = doc.createTextNode((String)value);
            if (toReplace != null) {
                root.replaceChild(textNode, toReplace);
            } else {
                root.appendChild(textNode);
            }
        } else {
            QName qname = ((XMLRoot)originalObject).getSchemaType();
            if (qname != null && !qname.equals(XMLConstants.STRING_QNAME)) {
                xmlRootField.setSchemaType(qname);
                xmlRootField.setIsTypedTextField(true);
                xmlRootField.addJavaConversion(value.getClass(), qname);
            }
            XPathEngine.getInstance().create(xmlRootField, root, value, session);
        }
    }

    public XMLConverter getConverter() {
        return this.converter;
    }

    public void setConverter(XMLConverter converter) {
        this.converter = converter;
    }

    public boolean isMixedContent() {
        return this.isMixedContent;
    }

    public void setMixedContent(boolean mixed) {
        this.isMixedContent = mixed;
    }
}

