/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.MarshalRecordContentHandler;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NodeRecord
extends MarshalRecord {
    private Document document;
    private Node node;

    public NodeRecord() {
        XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.document = xmlPlatform.createDocument();
        this.node = this.document;
    }

    public NodeRecord(String rootElementName) {
        this(rootElementName, (NamespaceResolver)null);
    }

    public NodeRecord(String rootElementName, NamespaceResolver namespaceResolver) {
        this();
        String rootElementNamespaceURI = this.resolveNamespace(namespaceResolver, rootElementName);
        Element rootElement = this.document.createElementNS(rootElementNamespaceURI, rootElementName);
        this.document.appendChild(rootElement);
        this.setDOM(rootElement);
    }

    public NodeRecord(String localRootElementName, Node parent) {
        this(localRootElementName, null, parent);
    }

    public NodeRecord(String localRootElementName, NamespaceResolver namespaceResolver, Node parent) {
        this();
        Document document = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        String localRootElementNamespaceURI = this.resolveNamespace(namespaceResolver, localRootElementName);
        Element child = document.createElementNS(localRootElementNamespaceURI, localRootElementName);
        parent.appendChild(child);
        this.setDOM(child);
    }

    public NodeRecord(Node node) {
        this.setDOM(node);
    }

    public String getLocalName() {
        return this.node.getLocalName();
    }

    public String getNamespaceURI() {
        return this.node.getNamespaceURI();
    }

    public void clear() {
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getDOM() {
        return (Element)this.node;
    }

    public void setDOM(Node dom) {
        short nodeType = dom.getNodeType();
        if (9 == nodeType) {
            this.document = (Document)dom;
            this.node = dom;
        } else if (1 == nodeType || 11 == nodeType) {
            this.document = dom.getOwnerDocument();
            this.node = dom;
            this.getNamespaceResolver().setDOM(dom);
        } else {
            throw XMLMarshalException.marshalException(null);
        }
    }

    public String transformToXML() {
        return null;
    }

    public void startDocument(String encoding, String version) {
    }

    public void endDocument() {
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            NodeRecordContentHandler mrcHdlr = new NodeRecordContentHandler(this, namespaceResolver);
            XMLFragmentReader xfRdr = new XMLFragmentReader(namespaceResolver);
            xfRdr.setContentHandler(mrcHdlr);
            try {
                xfRdr.parse(node);
            }
            catch (SAXException sAXException) {}
        }
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        Element element = this.document.createElementNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment));
        this.node = this.node.appendChild(element);
    }

    public void element(XPathFragment frag) {
        Element element = this.document.createElementNS(frag.getNamespaceURI(), this.getNameForFragment(frag));
        this.node.appendChild(element);
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        if (this.node.getNodeType() == 1) {
            this.getDOM().setAttributeNS(xPathFragment.getNamespaceURI(), this.getNameForFragment(xPathFragment), value);
        }
    }

    public void attribute(String namespaceURI, String localName, String qName, String value) {
        if (this.node.getNodeType() == 1) {
            this.getDOM().setAttributeNS(namespaceURI, qName, value);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.node = this.node.getParentNode();
    }

    public void characters(String value) {
        if (value.length() > 0) {
            this.node.appendChild(this.document.createTextNode(value));
        }
    }

    public void cdata(String value) {
        CDATASection cdata = this.document.createCDATASection(value);
        this.node.appendChild(cdata);
    }

    private String resolveNamespace(NamespaceResolver namespaceResolver, String localName) {
        int colonIndex = localName.indexOf(58);
        if (colonIndex < 0) {
            if (namespaceResolver != null) {
                return namespaceResolver.resolveNamespacePrefix("");
            }
            return null;
        }
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(localName);
        }
        String prefix = localName.substring(0, colonIndex);
        String uri = namespaceResolver.resolveNamespacePrefix(prefix);
        if (uri == null) {
            throw XMLMarshalException.namespaceNotFound(prefix);
        }
        return uri;
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    protected class NodeRecordContentHandler
    extends MarshalRecordContentHandler {
        Map<String, String> prefixMappings;

        public NodeRecordContentHandler(NodeRecord nRec, NamespaceResolver resolver) {
            super(nRec, resolver);
            this.prefixMappings = new HashMap<String, String>();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            Element element = namespaceURI == null ? NodeRecord.this.document.createElement(qName) : NodeRecord.this.document.createElementNS(namespaceURI, qName);
            NodeRecord.this.node = NodeRecord.this.node.appendChild(element);
            int i = 0;
            while (i < atts.getLength()) {
                this.marshalRecord.attribute(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), atts.getValue(i));
                ++i;
            }
            if (!this.prefixMappings.isEmpty()) {
                for (Map.Entry<String, String> entry : this.prefixMappings.entrySet()) {
                    String namespaceDeclarationPrefix = entry.getKey();
                    if (namespaceDeclarationPrefix == null || namespaceDeclarationPrefix.length() == 0) {
                        String namespaceDeclarationURI = entry.getValue();
                        if (namespaceDeclarationURI == null) {
                            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
                            continue;
                        }
                        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceDeclarationURI);
                        continue;
                    }
                    element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + entry.getKey(), entry.getValue());
                }
                this.prefixMappings.clear();
            }
            this.marshalRecord.closeStartElement();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            String namespaceUri = NodeRecord.this.getNamespaceResolver().resolveNamespacePrefix(prefix);
            if (namespaceUri == null || !namespaceUri.equals(uri)) {
                this.prefixMappings.put(prefix, uri);
            }
        }
    }
}

