/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.security.AccessController;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.queries.JPAQueryBuilder;

public final class JPAQueryBuilderManager {
    private static JPAQueryBuilder systemQueryBuilder;

    private static JPAQueryBuilder buildDefaultQueryBuilder() {
        try {
            Class parserClass = JPAQueryBuilderManager.loadParserClass();
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                return (JPAQueryBuilder)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(parserClass));
            }
            return (JPAQueryBuilder)PrivilegedAccessHelper.newInstanceFromClass(parserClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Could not load the parser class.", e);
        }
    }

    public static JPAQueryBuilder getQueryBuilder() {
        if (systemQueryBuilder == null) {
            systemQueryBuilder = JPAQueryBuilderManager.buildDefaultQueryBuilder();
        }
        return systemQueryBuilder;
    }

    private static Class loadParserClass() throws Exception {
        String parserClassName = "org.eclipse.persistence.queries.ANTLRQueryBuilder";
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (Class)AccessController.doPrivileged(new PrivilegedClassForName(parserClassName));
        }
        return PrivilegedAccessHelper.getClassForName(parserClassName);
    }

    public static void setQueryBuilder(JPAQueryBuilder queryBuilder) {
        systemQueryBuilder = queryBuilder;
    }
}

