/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.AbstractSemanticValidator;
import org.eclipse.persistence.jpa.jpql.AbstractValidator;
import org.eclipse.persistence.jpa.jpql.DefaultLiteralVisitor;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.GenericSemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.ITypeHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.LiteralType;
import org.eclipse.persistence.jpa.jpql.LiteralVisitor;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AbstractTraverseParentVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.spi.JPAVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSemanticValidator
extends AbstractSemanticValidator {
    protected NullValueVisitor nullValueVisitor;
    protected UpdateClauseAbstractSchemaNameFinder updateClauseAbstractSchemaNameFinder;
    protected Map<Class<? extends TypeValidator>, TypeValidator> validators;

    public DefaultSemanticValidator(JPQLQueryContext queryContext) {
        super(new GenericSemanticValidatorHelper(queryContext));
    }

    public DefaultSemanticValidator(SemanticValidatorHelper helper) {
        super(helper);
    }

    protected boolean areTypesEquivalent(Object[] typeDeclarations1, Object[] typeDeclarations2) {
        if (typeDeclarations1.length == 0 && typeDeclarations2.length == 0) {
            return true;
        }
        if (typeDeclarations1.length != typeDeclarations2.length) {
            return false;
        }
        int index = typeDeclarations1.length;
        while (--index >= 0) {
            if (this.helper.isTypeDeclarationAssignableTo(typeDeclarations1[index], typeDeclarations2[index])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected LiteralVisitor buildLiteralVisitor() {
        return new DefaultLiteralVisitor();
    }

    protected ResultVariableInOrderByVisitor buildResultVariableInOrderByVisitor() {
        return new ResultVariableInOrderByVisitor();
    }

    protected AbstractSchemaName findAbstractSchemaName(UpdateItem expression) {
        UpdateClauseAbstractSchemaNameFinder visitor = this.getUpdateClauseAbstractSchemaNameFinder();
        try {
            expression.accept(visitor);
            AbstractSchemaName abstractSchemaName = visitor.expression;
            return abstractSchemaName;
        }
        finally {
            visitor.expression = null;
        }
    }

    protected NullValueVisitor getNullValueVisitor() {
        if (this.nullValueVisitor == null) {
            this.nullValueVisitor = new NullValueVisitor();
        }
        return this.nullValueVisitor;
    }

    protected Object getType(Expression expression) {
        return this.helper.getType(expression);
    }

    protected ITypeHelper getTypeHelper() {
        return this.helper.getTypeHelper();
    }

    protected UpdateClauseAbstractSchemaNameFinder getUpdateClauseAbstractSchemaNameFinder() {
        if (this.updateClauseAbstractSchemaNameFinder == null) {
            this.updateClauseAbstractSchemaNameFinder = new UpdateClauseAbstractSchemaNameFinder();
        }
        return this.updateClauseAbstractSchemaNameFinder;
    }

    protected TypeValidator getValidator(Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.validators.get(validatorClass);
        if (validator == null) {
            try {
                Constructor<? extends TypeValidator> constructor = validatorClass.getDeclaredConstructor(DefaultSemanticValidator.class);
                constructor.setAccessible(true);
                validator = constructor.newInstance(this);
                this.validators.put(validatorClass, validator);
            }
            catch (Exception exception) {}
        }
        return validator;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.validators = new HashMap<Class<? extends TypeValidator>, TypeValidator>();
    }

    protected boolean isBooleanType(Expression expression) {
        return this.isValid(expression, BooleanTypeValidator.class);
    }

    protected boolean isComparisonEquivalentType(Expression expression1, Expression expression2) {
        Object type1 = this.helper.getType(expression1);
        Object type2 = this.helper.getType(expression2);
        ITypeHelper typeHelper = this.getTypeHelper();
        return type1 == type2 || !this.helper.isTypeResolvable(type1) || !this.helper.isTypeResolvable(type2) || typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2) || this.helper.isAssignableTo(type1, type2) || this.helper.isAssignableTo(type2, type1);
    }

    protected boolean isEquivalentBetweenType(Expression expression1, Expression expression2) {
        Object type1 = this.helper.getType(expression1);
        Object type2 = this.helper.getType(expression2);
        if (!this.helper.isTypeResolvable(type1) || !this.helper.isTypeResolvable(type2)) {
            return true;
        }
        ITypeHelper typeHelper = this.getTypeHelper();
        if (type1 == type2) {
            return typeHelper.isNumericType(type1) || typeHelper.isStringType(type1) || typeHelper.isDateType(type1);
        }
        return typeHelper.isNumericType(type1) && typeHelper.isNumericType(type2) || typeHelper.isStringType(type1) && typeHelper.isStringType(type2) || typeHelper.isDateType(type1) && typeHelper.isDateType(type2);
    }

    protected boolean isIntegralType(Expression expression) {
        if (this.isNumericType(expression)) {
            ITypeHelper typeHelper = this.getTypeHelper();
            Object type = this.helper.getType(expression);
            return type == typeHelper.unknownType() || typeHelper.isIntegralType(type);
        }
        return false;
    }

    protected boolean isNullValue(Expression expression) {
        NullValueVisitor visitor = this.getNullValueVisitor();
        try {
            expression.accept(visitor);
            boolean bl = visitor.valid;
            return bl;
        }
        finally {
            visitor.valid = false;
        }
    }

    protected boolean isNumericType(Expression expression) {
        return this.isValid(expression, NumericTypeValidator.class);
    }

    protected boolean isStringType(Expression expression) {
        return this.isValid(expression, StringTypeValidator.class);
    }

    protected boolean isValid(Expression expression, Class<? extends TypeValidator> validatorClass) {
        TypeValidator validator = this.getValidator(validatorClass);
        try {
            expression.accept(validator);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    protected boolean isValidWithFindQueryBNF(AbstractExpression expression, String queryBNF) {
        AbstractValidator.BNFValidator validator = this.getExpressionValidator(queryBNF);
        try {
            JPQLQueryBNF childQueryBNF = expression.getParent().findQueryBNF(expression);
            validator.validate(childQueryBNF);
            boolean bl = validator.valid;
            return bl;
        }
        finally {
            validator.valid = false;
        }
    }

    @Override
    protected void validateAbsExpression(AbsExpression expression) {
        this.validateNumericType(expression.getExpression(), "ABS_EXPRESSION_INVALID_NUMERIC_EXPRESSION");
    }

    @Override
    protected void validateArithmeticExpression(ArithmeticExpression expression, String leftExpressionWrongTypeMessageKey, String rightExpressionWrongTypeMessageKey) {
        this.validateNumericType(expression.getLeftExpression(), leftExpressionWrongTypeMessageKey);
        this.validateNumericType(expression.getRightExpression(), rightExpressionWrongTypeMessageKey);
    }

    @Override
    protected void validateAvgFunction(AvgFunction expression) {
        this.validateNumericType(expression.getExpression(), "AVG_FUNCTION_INVALID_NUMERIC_EXPRESSION");
    }

    @Override
    protected void validateBetweenRangeExpression(BetweenExpression expression) {
        if (!this.isEquivalentBetweenType(expression.getExpression(), expression.getLowerBoundExpression()) || !this.isEquivalentBetweenType(expression.getExpression(), expression.getUpperBoundExpression())) {
            this.addProblem(expression, "BETWEEN_EXPRESSION_WRONG_TYPE");
        }
    }

    protected void validateBooleanType(Expression expression, String messageKey) {
        if (this.isValid(expression, "boolean_primary") && !this.isBooleanType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    @Override
    protected void validateCollectionMemberEntityExpression(CollectionMemberExpression expression) {
        Expression entityExpression = expression.getEntityExpression();
        Object type = this.helper.getType(entityExpression);
        if (this.helper.getEmbeddable(type) != null) {
            this.addProblem(entityExpression, "COLLECTION_MEMBER_EXPRESSION_EMBEDDABLE");
        }
    }

    @Override
    protected void validateComparisonExpression(ComparisonExpression expression) {
        if (!this.isComparisonEquivalentType(expression.getLeftExpression(), expression.getRightExpression())) {
            this.addProblem(expression, "COMPARISON_EXPRESSION_WRONG_COMPARISON_TYPE");
        }
    }

    @Override
    protected void validateConcatExpression(ConcatExpression expression) {
        if (expression.hasExpression()) {
            for (Expression child : this.getChildren(expression.getExpression())) {
                this.validateStringType(child, "CONCAT_EXPRESSION_EXPRESSION_WRONG_TYPE");
            }
        }
    }

    @Override
    protected void validateConstructorExpression(ConstructorExpression expression) {
        String className = expression.getClassName();
        if (ExpressionTools.stringIsNotEmpty(className)) {
            Object type = this.helper.getType(className);
            if (!this.helper.isTypeResolvable(type)) {
                int startPosition = this.position(expression) + 4;
                int endPosition = startPosition + className.length();
                this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_UNKNOWN_TYPE", className);
            } else if (expression.hasLeftParenthesis() && expression.hasConstructorItems()) {
                Expression constructorItems = expression.getConstructorItems();
                List<Expression> children = this.getChildren(constructorItems);
                Object[] typeDeclarations = null;
                boolean constructorFound = false;
                Object[] objectArray = this.helper.getConstructors(type);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object constructor = objectArray[n2];
                    Object[] parameterTypeDeclarations = this.helper.getMethodParameterTypeDeclarations(constructor);
                    if (children.size() == parameterTypeDeclarations.length) {
                        if (parameterTypeDeclarations.length == 0) {
                            constructor = true;
                        } else {
                            if (typeDeclarations == null) {
                                typeDeclarations = new Object[children.size()];
                                int index = children.size();
                                while (--index >= 0) {
                                    typeDeclarations[index] = this.helper.getTypeDeclaration(children.get(index));
                                }
                            }
                            if (constructorFound = this.areTypesEquivalent(parameterTypeDeclarations, typeDeclarations)) break;
                        }
                    }
                    ++n2;
                }
                if (!constructorFound) {
                    int startPosition = this.position(expression) + 4;
                    int endPosition = startPosition + className.length();
                    this.addProblem((Expression)expression, startPosition, endPosition, "CONSTRUCTOR_EXPRESSION_UNDEFINED_CONSTRUCTOR", new String[0]);
                }
            }
        }
    }

    @Override
    protected void validateCountFunction(CountFunction expression) {
        Expression childExpression;
        Object type;
        if (expression.hasExpression() && expression.hasDistinct() && this.helper.getEmbeddable(type = this.helper.getType(childExpression = expression.getExpression())) != null) {
            int distinctLength = "DISTINCT".length() + 1;
            int startIndex = this.position(childExpression) - distinctLength;
            int endIndex = startIndex + this.length(childExpression) + distinctLength;
            this.addProblem((Expression)expression, startIndex, endIndex, "COUNT_FUNCTION_DISTINCT_EMBEDDABLE", new String[0]);
        }
    }

    @Override
    protected void validateIdentificationVariable(IdentificationVariable expression) {
        if (!expression.isVirtual()) {
            String variable = expression.getText();
            boolean continueValidating = true;
            if (this.isComparingEntityTypeLiteral(expression)) {
                Object entity = this.helper.getEntityNamed(variable);
                boolean bl = continueValidating = entity == null;
            }
            if (continueValidating) {
                if (this.registerIdentificationVariable) {
                    this.usedIdentificationVariables.add(expression);
                }
                if (ExpressionTools.stringIsNotEmpty(variable)) {
                    this.validateIdentificationVariable(expression, variable);
                }
            }
        } else {
            StateFieldPathExpression pathExpression = expression.getStateFieldPathExpression();
            if (pathExpression != null) {
                pathExpression.accept(this);
            }
        }
    }

    @Override
    protected void validateIdentificationVariable(IdentificationVariable expression, String variable) {
        String[] stringArray = this.helper.entityNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entityName = stringArray[n2];
            if (variable.equalsIgnoreCase(entityName) && !this.isValidWithFindQueryBNF(expression, "literal")) {
                int startIndex = this.position(expression);
                int endIndex = startIndex + variable.length();
                this.addProblem((Expression)expression, startIndex, endIndex, "IDENTIFICATION_VARIABLE_ENTITY_NAME", new String[0]);
                break;
            }
            ++n2;
        }
    }

    protected void validateIntegralType(Expression expression, String queryBNF, String messageKey) {
        if (this.isValid(expression, queryBNF) && !this.isIntegralType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    @Override
    protected void validateLengthExpression(LengthExpression expression) {
        this.validateStringType(expression.getExpression(), "LENGTH_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateLocateExpression(LocateExpression expression) {
        this.validateStringType(expression.getFirstExpression(), "LOCATE_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateStringType(expression.getSecondExpression(), "LOCATE_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
        this.validateNumericType(expression.getThirdExpression(), "LOCATE_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateLowerExpression(LowerExpression expression) {
        this.validateStringType(expression.getExpression(), "LOWER_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateMapIdentificationVariable(EncapsulatedIdentificationVariableExpression expression) {
        Expression childExpression;
        String variableName;
        if (expression.hasExpression() && ExpressionTools.stringIsNotEmpty(variableName = this.literal(childExpression = expression.getExpression(), LiteralType.IDENTIFICATION_VARIABLE))) {
            Object typeDeclaration = this.helper.getTypeDeclaration(childExpression);
            Object type = this.helper.getType(typeDeclaration);
            if (!this.getTypeHelper().isMapType(type)) {
                this.addProblem(childExpression, "ENCAPSULATED_IDENTIFICATION_VARIABLE_EXPRESSION_NOT_MAP_VALUED", expression.getIdentifier());
            }
        }
    }

    @Override
    protected void validateModExpression(ModExpression expression) {
        this.validateIntegralType(expression.getFirstExpression(), expression.parameterExpressionBNF(0), "MOD_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateIntegralType(expression.getSecondExpression(), expression.parameterExpressionBNF(1), "MOD_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateNotExpression(NotExpression expression) {
        this.validateBooleanType(expression.getExpression(), "NOT_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateNullComparisonExpression(NullComparisonExpression expression) {
        Object type;
        StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getExpression());
        if (pathExpression != null && this.helper.getEmbeddable(type = this.helper.getType(pathExpression)) != null) {
            this.addProblem((Expression)pathExpression, "NULL_COMPARISON_EXPRESSION_INVALID_TYPE", pathExpression.toParsedText());
            return;
        }
    }

    protected void validateNumericType(Expression expression, String messageKey) {
        if (this.isValid(expression, "simple_arithmetic_expression") && !this.isNumericType(expression)) {
            this.addProblem(expression, messageKey);
        }
    }

    @Override
    protected void validateSqrtExpression(SqrtExpression expression) {
        this.validateNumericType(expression.getExpression(), "SQRT_EXPRESSION_WRONG_TYPE");
    }

    protected void validateStringType(Expression expression, String messageKey) {
        if (this.isValid(expression, "string_primary") && !this.isStringType(expression)) {
            this.addProblem(expression, messageKey, expression.toParsedText());
        }
    }

    @Override
    protected void validateSubstringExpression(SubstringExpression expression) {
        this.validateStringType(expression.getFirstExpression(), "SUBSTRING_EXPRESSION_FIRST_EXPRESSION_WRONG_TYPE");
        this.validateIntegralType(expression.getSecondExpression(), expression.parameterExpressionBNF(1), "SUBSTRING_EXPRESSION_SECOND_EXPRESSION_WRONG_TYPE");
        if (this.getJPAVersion().isNewerThanOrEqual(JPAVersion.VERSION_2_0)) {
            this.validateIntegralType(expression.getThirdExpression(), expression.parameterExpressionBNF(2), "SUBSTRING_EXPRESSION_THIRD_EXPRESSION_WRONG_TYPE");
        }
    }

    @Override
    protected void validateSubtractionExpression(SubtractionExpression expression) {
        this.validateArithmeticExpression(expression, "SUBTRACTION_EXPRESSION_LEFT_EXPRESSION_WRONG_TYPE", "SUBTRACTION_EXPRESSION_RIGHT_EXPRESSION_WRONG_TYPE");
    }

    @Override
    protected void validateSumFunction(SumFunction expression) {
        this.validateNumericType(expression.getExpression(), "SUM_FUNCTION_WRONG_TYPE");
    }

    @Override
    protected boolean validateUpdateItem(UpdateItem expression) {
        boolean valid = super.validateUpdateItem(expression);
        if (valid) {
            Object entity;
            String entityName;
            AbstractSchemaName abstractSchemaName = this.findAbstractSchemaName(expression);
            String string = entityName = abstractSchemaName != null ? abstractSchemaName.getText() : null;
            if (ExpressionTools.stringIsNotEmpty(entityName) && (entity = this.helper.getEntityNamed(entityName)) != null && expression.hasSpaceAfterStateFieldPathExpression()) {
                String stateFieldValue;
                StateFieldPathExpression pathExpression = this.getStateFieldPathExpression(expression.getStateFieldPathExpression());
                String string2 = stateFieldValue = pathExpression != null ? pathExpression.toParsedText() : null;
                if (ExpressionTools.stringIsNotEmpty(stateFieldValue)) {
                    if (stateFieldValue.indexOf(".") == -1) {
                        Object mapping = this.helper.getMappingNamed(entity, stateFieldValue);
                        if (mapping == null) {
                            this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                        } else {
                            this.validateUpdateItemTypes(expression, this.helper.getMappingType(mapping));
                        }
                    } else {
                        Object type = this.helper.getType(pathExpression);
                        if (!this.helper.isTypeResolvable(type)) {
                            this.addProblem((Expression)pathExpression, "UPDATE_ITEM_NOT_RESOLVABLE", stateFieldValue);
                        } else {
                            this.validateUpdateItemTypes(expression, type);
                        }
                    }
                }
            }
        }
        return valid;
    }

    protected void validateUpdateItemTypes(UpdateItem expression, Object type) {
        if (expression.hasNewValue()) {
            Expression newValue = expression.getNewValue();
            ITypeHelper typeHelper = this.getTypeHelper();
            boolean nullValue = this.isNullValue(newValue);
            if (nullValue) {
                if (typeHelper.isPrimitiveType(type)) {
                    this.addProblem(expression, "UPDATE_ITEM_NULL_NOT_ASSIGNABLE_TO_PRIMITIVE");
                }
                return;
            }
            Object newValueType = this.getType(newValue);
            if (!this.helper.isTypeResolvable(newValueType) || typeHelper.isDateType(type) && typeHelper.isDateType(newValueType) || (typeHelper.isNumericType(type) || typeHelper.isPrimitiveType(type)) && (typeHelper.isNumericType(newValueType) || typeHelper.isPrimitiveType(newValueType))) {
                return;
            }
            if (!this.helper.isAssignableTo(newValueType, type)) {
                this.addProblem((Expression)expression, "UPDATE_ITEM_NOT_ASSIGNABLE", this.helper.getTypeName(newValueType), this.helper.getTypeName(type));
            }
        }
    }

    @Override
    protected void validateUpperExpression(UpperExpression expression) {
        this.validateStringType(expression.getExpression(), "UPPER_EXPRESSION_WRONG_TYPE");
    }

    protected class BooleanTypeValidator
    extends TypeValidator {
        protected BooleanTypeValidator() {
        }

        protected boolean isRightType(Object type) {
            return DefaultSemanticValidator.this.getTypeHelper().isBooleanType(type);
        }

        public void visit(AllOrAnyExpression expression) {
            this.valid = true;
        }

        public void visit(AndExpression expression) {
            this.valid = true;
        }

        public void visit(BetweenExpression expression) {
            this.valid = true;
        }

        public void visit(ComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(EmptyCollectionComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(ExistsExpression expression) {
            this.valid = true;
        }

        public void visit(KeywordExpression expression) {
            this.valid = true;
        }

        public void visit(LikeExpression expression) {
            this.valid = true;
        }

        public void visit(NotExpression expression) {
            this.valid = true;
        }

        public void visit(NullComparisonExpression expression) {
            this.valid = true;
        }

        public void visit(OrExpression expression) {
            this.valid = true;
        }
    }

    protected static class CollectionValuedPathExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionValuedPathExpression expression;

        protected CollectionValuedPathExpressionVisitor() {
        }

        public void visit(CollectionValuedPathExpression expression) {
            this.expression = expression;
        }
    }

    protected class NullValueVisitor
    extends AbstractExpressionVisitor {
        protected boolean valid;

        protected NullValueVisitor() {
        }

        public void visit(KeywordExpression expression) {
            this.valid = expression.getText() == "NULL";
        }
    }

    protected class NumericTypeValidator
    extends TypeValidator {
        protected NumericTypeValidator() {
        }

        protected boolean isRightType(Object type) {
            return DefaultSemanticValidator.this.getTypeHelper().isNumericType(type);
        }

        public void visit(AbsExpression expression) {
            this.valid = true;
        }

        public void visit(AdditionExpression expression) {
            this.valid = true;
        }

        public void visit(ArithmeticFactor expression) {
            this.valid = true;
        }

        public void visit(AvgFunction expression) {
            this.valid = true;
        }

        public void visit(CountFunction expression) {
            this.valid = true;
        }

        public void visit(DivisionExpression expression) {
            this.valid = true;
        }

        public void visit(IndexExpression expression) {
            this.valid = true;
        }

        public void visit(LengthExpression expression) {
            this.valid = true;
        }

        public void visit(LocateExpression expression) {
            this.valid = true;
        }

        public void visit(MaxFunction expression) {
            this.valid = true;
        }

        public void visit(MinFunction expression) {
            this.valid = true;
        }

        public void visit(ModExpression expression) {
            this.valid = true;
        }

        public void visit(MultiplicationExpression expression) {
            this.valid = true;
        }

        public void visit(NumericLiteral expression) {
            this.valid = true;
        }

        public void visit(SizeExpression expression) {
            this.valid = true;
        }

        public void visit(SqrtExpression expression) {
            this.valid = true;
        }

        public void visit(SubtractionExpression expression) {
            this.valid = true;
        }

        public void visit(SumFunction expression) {
            this.valid = true;
        }
    }

    protected class ResultVariableInOrderByVisitor
    extends AbstractExpressionVisitor {
        public boolean result;

        protected ResultVariableInOrderByVisitor() {
        }

        public void visit(IdentificationVariable expression) {
            expression.getParent().accept(this);
        }

        public void visit(OrderByClause expression) {
            this.result = true;
        }

        public void visit(OrderByItem expression) {
            expression.getParent().accept(this);
        }
    }

    protected static class StateFieldPathExpressionVisitor
    extends AbstractExpressionVisitor {
        protected StateFieldPathExpression expression;

        protected StateFieldPathExpressionVisitor() {
        }

        public void visit(StateFieldPathExpression expression) {
            this.expression = expression;
        }
    }

    protected class StringTypeValidator
    extends TypeValidator {
        protected StringTypeValidator() {
        }

        protected boolean isRightType(Object type) {
            return DefaultSemanticValidator.this.getTypeHelper().isStringType(type);
        }

        public void visit(ConcatExpression expression) {
            this.valid = true;
        }

        public void visit(LowerExpression expression) {
            this.valid = true;
        }

        public void visit(StringLiteral expression) {
            this.valid = true;
        }

        public void visit(SubstringExpression expression) {
            this.valid = true;
        }

        public void visit(TrimExpression expression) {
            this.valid = true;
        }

        public void visit(UpperExpression expression) {
            this.valid = true;
        }
    }

    protected abstract class TypeValidator
    extends AbstractExpressionVisitor {
        protected boolean valid;

        protected TypeValidator() {
        }

        protected abstract boolean isRightType(Object var1);

        public final void visit(CaseExpression expression) {
            Object type = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(CoalesceExpression expression) {
            Object type = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(InputParameter expression) {
            this.valid = true;
        }

        public void visit(NullExpression expression) {
            this.valid = true;
        }

        public final void visit(NullIfExpression expression) {
            expression.getFirstExpression().accept(this);
        }

        public final void visit(StateFieldPathExpression expression) {
            Object type = DefaultSemanticValidator.this.getType(expression);
            this.valid = this.isRightType(type);
        }

        public final void visit(SubExpression expression) {
            expression.getExpression().accept(this);
        }
    }

    protected class UpdateClauseAbstractSchemaNameFinder
    extends AbstractExpressionVisitor {
        protected AbstractSchemaName expression;

        protected UpdateClauseAbstractSchemaNameFinder() {
        }

        public void visit(AbstractSchemaName expression) {
            this.expression = expression;
        }

        public void visit(CollectionExpression expression) {
            expression.getParent().accept(this);
        }

        public void visit(RangeVariableDeclaration expression) {
            expression.getAbstractSchemaName().accept(this);
        }

        public void visit(UpdateClause expression) {
            expression.getRangeVariableDeclaration().accept(this);
        }

        public void visit(UpdateItem expression) {
            expression.getParent().accept(this);
        }
    }

    protected static class VirtualIdentificationVariableFinder
    extends AbstractTraverseParentVisitor {
        protected IdentificationVariable expression;
        protected boolean traverse;

        protected VirtualIdentificationVariableFinder() {
        }

        public void visit(DeleteClause expression) {
            try {
                this.traverse = true;
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.traverse = false;
            }
        }

        public void visit(DeleteStatement expression) {
            expression.getDeleteClause().accept(this);
        }

        public void visit(IdentificationVariable expression) {
            this.expression = expression;
        }

        public void visit(RangeVariableDeclaration expression) {
            if (this.traverse) {
                expression.getIdentificationVariable().accept(this);
            } else {
                super.visit(expression);
            }
        }

        public void visit(UpdateClause expression) {
            try {
                this.traverse = true;
                expression.getRangeVariableDeclaration().accept(this);
            }
            finally {
                this.traverse = false;
            }
        }

        public void visit(UpdateStatement expression) {
            expression.getUpdateClause().accept(this);
        }
    }
}

