/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.GenericTypeHelper;
import org.eclipse.persistence.jpa.jpql.ITypeHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.Resolver;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.StateFieldResolver;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.spi.IMapping;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.util.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSemanticValidatorHelper
implements SemanticValidatorHelper {
    private final JPQLQueryContext queryContext;
    private ITypeHelper typeHelper;

    public GenericSemanticValidatorHelper(JPQLQueryContext queryContext) {
        Assert.isNotNull(queryContext, "The JPQLQueryContext cannot be null");
        this.queryContext = queryContext;
    }

    private void addIdentificationVariable(IdentificationVariable identificationVariable, Map<String, List<IdentificationVariable>> identificationVariables) {
        String variableName;
        String string = variableName = identificationVariable != null ? identificationVariable.getVariableName() : null;
        if (ExpressionTools.stringIsNotEmpty(variableName)) {
            List<IdentificationVariable> variables = identificationVariables.get(variableName);
            if (variables == null) {
                variables = new ArrayList<IdentificationVariable>();
                identificationVariables.put(variableName, variables);
            }
            variables.add(identificationVariable);
        }
    }

    @Override
    public void collectAllDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        JPQLQueryContext currentContext = this.queryContext.getCurrentContext();
        while (currentContext != null) {
            this.collectLocalDeclarationIdentificationVariables(currentContext, identificationVariables);
            currentContext = currentContext.getParent();
        }
    }

    private void collectLocalDeclarationIdentificationVariables(JPQLQueryContext queryContext, Map<String, List<IdentificationVariable>> identificationVariables) {
        for (DeclarationResolver.Declaration declaration : queryContext.getActualDeclarationResolver().getDeclarations()) {
            IdentificationVariable identificationVariable = declaration.identificationVariable;
            this.addIdentificationVariable(identificationVariable, identificationVariables);
            for (IdentificationVariable joinIdentificationVariable : declaration.joins.values()) {
                this.addIdentificationVariable(joinIdentificationVariable, identificationVariables);
            }
        }
    }

    @Override
    public void collectLocalDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        this.collectLocalDeclarationIdentificationVariables(this.queryContext, identificationVariables);
    }

    @Override
    public void disposeSubqueryContext() {
        this.queryContext.disposeSubqueryContext();
    }

    @Override
    public String[] entityNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IEntity entity : this.queryContext.getProvider().entities()) {
            names.add(entity.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public IConstructor[] getConstructors(Object type) {
        return CollectionTools.array(IConstructor.class, ((IType)type).constructors());
    }

    public List getDeclarations() {
        return this.queryContext.getDeclarations();
    }

    @Override
    public IManagedType getEmbeddable(Object type) {
        return this.queryContext.getProvider().getEmbeddable((IType)type);
    }

    @Override
    public IEntity getEntityNamed(String entityName) {
        return this.queryContext.getProvider().getEntityNamed(entityName);
    }

    @Override
    public String[] getEnumConstants(Object type) {
        return ((IType)type).getEnumConstants();
    }

    @Override
    public JPQLGrammar getGrammar() {
        return this.queryContext.getGrammar();
    }

    @Override
    public IManagedType getManagedType(Expression expression) {
        return this.queryContext.getResolver(expression).getManagedType();
    }

    @Override
    public IMapping getMappingNamed(Object managedType, String path) {
        return ((IManagedType)managedType).getMappingNamed(path);
    }

    @Override
    public IType getMappingType(Object mapping) {
        return mapping != null ? ((IMapping)mapping).getType() : this.queryContext.getTypeHelper().unknownType();
    }

    public ITypeDeclaration[] getMethodParameterTypeDeclarations(Object constructor) {
        return ((IConstructor)constructor).getParameterTypes();
    }

    @Override
    public IType getType(Expression expression) {
        return this.queryContext.getType(expression);
    }

    @Override
    public IType getType(Object typeDeclaration) {
        return ((ITypeDeclaration)typeDeclaration).getType();
    }

    @Override
    public IType getType(String typeName) {
        return this.queryContext.getType(typeName);
    }

    @Override
    public ITypeDeclaration getTypeDeclaration(Expression expression) {
        return this.queryContext.getTypeDeclaration(expression);
    }

    @Override
    public ITypeHelper getTypeHelper() {
        if (this.typeHelper == null) {
            this.typeHelper = new GenericTypeHelper(this.queryContext.getTypeHelper());
        }
        return this.typeHelper;
    }

    @Override
    public String getTypeName(Object type) {
        return ((IType)type).getName();
    }

    @Override
    public boolean isAssignableTo(Object type1, Object type2) {
        return ((IType)type1).isAssignableTo((IType)type2);
    }

    @Override
    public boolean isCollectionIdentificationVariable(String variableName) {
        return this.queryContext.isCollectionIdentificationVariable(variableName);
    }

    @Override
    public boolean isCollectionMapping(Object mapping) {
        return mapping != null && ((IMapping)mapping).isCollection();
    }

    @Override
    public boolean isEnumType(Object type) {
        return ((IType)type).isEnum();
    }

    @Override
    public boolean isManagedTypeResolvable(Object managedType) {
        return ((IManagedType)managedType).getType().isResolvable();
    }

    @Override
    public boolean isPropertyMapping(Object mapping) {
        return mapping != null && ((IMapping)mapping).isProperty();
    }

    @Override
    public boolean isRelationshipMapping(Object mapping) {
        return mapping != null && ((IMapping)mapping).isRelationship();
    }

    @Override
    public boolean isTransient(Object mapping) {
        return mapping != null && ((IMapping)mapping).isTransient();
    }

    @Override
    public boolean isTypeDeclarationAssignableTo(Object typeDeclaration1, Object typeDeclaration2) {
        ITypeDeclaration declaration1 = (ITypeDeclaration)typeDeclaration1;
        ITypeDeclaration declaration2 = (ITypeDeclaration)typeDeclaration2;
        if (declaration1.isArray() && !declaration2.isArray() || !declaration1.isArray() && declaration2.isArray()) {
            return false;
        }
        if (declaration1.isArray()) {
            return declaration1.getDimensionality() == declaration2.getDimensionality();
        }
        return this.isAssignableTo(declaration1.getType(), declaration2.getType());
    }

    @Override
    public boolean isTypeResolvable(Object type) {
        return ((IType)type).isResolvable();
    }

    @Override
    public void newSubqueryContext(SimpleSelectStatement expression) {
        this.queryContext.newSubqueryContext(expression);
    }

    @Override
    public IMapping resolveMapping(Expression expression) {
        return this.queryContext.getResolver(expression).getMapping();
    }

    @Override
    public IMapping resolveMapping(String variableName, String name) {
        Resolver parent = this.queryContext.getResolver(variableName);
        Resolver resolver = parent.getChild(name);
        if (resolver == null) {
            resolver = new StateFieldResolver(parent, name);
            parent.addChild(variableName, resolver);
        }
        return resolver.getMapping();
    }
}

