/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConditionalClause
extends AbstractExpression {
    private AbstractExpression conditionalExpression;
    private boolean hasSpace;
    private String identifier;

    protected AbstractConditionalClause(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getConditionalExpression().accept(visitor);
    }

    @Override
    protected final void addChildrenTo(Collection<Expression> children) {
        children.add(this.getConditionalExpression());
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpace) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.conditionalExpression != null) {
            children.add(this.conditionalExpression);
        }
    }

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getConditionalExpression() {
        if (this.conditionalExpression == null) {
            this.conditionalExpression = this.buildNullExpression();
        }
        return this.conditionalExpression;
    }

    public final String getIdentifier() {
        return this.getText();
    }

    public final boolean hasConditionalExpression() {
        return this.conditionalExpression != null && !this.conditionalExpression.isNull();
    }

    public final boolean hasSpaceAfterIdentifier() {
        return this.hasSpace;
    }

    @Override
    protected boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return wordParser.character() == ')' || super.isParsingComplete(wordParser, word, expression);
    }

    protected final Expression parse(CharSequence expression, boolean tolerant) {
        this.conditionalExpression = this.parse(new WordParser(expression), this.getQueryBNF("conditional_expression"), tolerant);
        this.hasSpace = true;
        return this.conditionalExpression;
    }

    @Override
    protected final void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward(this.getText());
        this.hasSpace = wordParser.skipLeadingWhitespace() > 0;
        this.conditionalExpression = this.parse(wordParser, this.getQueryBNF("conditional_expression"), tolerant);
    }

    @Override
    protected boolean shouldSkipLiteral(AbstractExpression expression) {
        return false;
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpace) {
            writer.append(' ');
        }
        if (this.conditionalExpression != null) {
            this.conditionalExpression.toParsedText(writer, actual);
        }
    }
}

